package tk.eclipse.plugin.struts;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;

import tk.eclipse.plugin.htmleditor.JavaUtil;

public class PropertyInfo {
	
	private IType parentType;
	private String propertyName;
	private String propertyType;
	
	public PropertyInfo(IType parentType, String propertyName,String propertyType){
		this.parentType = parentType;
		this.propertyName = propertyName;
		this.propertyType = propertyType;
	}
	
	public String getPropertyName() {
		return propertyName;
	}
	
	public String getPropertyType() {
		return propertyType;
	}
	
	public PropertyInfo[] getProperties(){
		try {
			IJavaProject project = parentType.getJavaProject();
			String clazz = JavaUtil.getFullQName(parentType, this.propertyType);
			return Util.getProperties(project.findType(clazz));
		} catch(Exception ex){
			return new PropertyInfo[0];
		}
	}
	
	public PropertyInfo[] getListProperties(){
		try {
			String propertyType = this.propertyType;
			if(propertyType.endsWith("[]")){
				propertyType = propertyType.replace("[]", "");
			} else if(propertyType.endsWith(">")){
				propertyType = propertyType.replaceAll("(.+<)|>", "");
			} else {
				return new PropertyInfo[0];
			}
			IJavaProject project = parentType.getJavaProject();
			String clazz = JavaUtil.getFullQName(parentType, propertyType);
			return Util.getProperties(project.findType(clazz));
		} catch(Exception ex){
			return new PropertyInfo[0];
		}
	}
	
	public PropertyInfo getProperty(String propertyName){
		for(PropertyInfo properyInfo: getProperties()){
			if(properyInfo.getPropertyName().equals(propertyName)){
				return properyInfo;
			}
		}
		return null;
	}
	
	public PropertyInfo getListProperty(String propertyName){
		for(PropertyInfo properyInfo: getListProperties()){
			if(properyInfo.getPropertyName().equals(propertyName)){
				return properyInfo;
			}
		}
		return null;
	}
	
	public boolean hasProperty(String propertyName){
		for(PropertyInfo properyInfo: getProperties()){
			if(properyInfo.getPropertyName().equals(propertyName)){
				return true;
			}
		}
		return false;
	}
	
	public boolean hasListProperty(String propertyName){
		for(PropertyInfo properyInfo: getListProperties()){
			if(properyInfo.getPropertyName().equals(propertyName)){
				return true;
			}
		}
		return false;
	}
}
