package tk.eclipse.plugin.struts;

import java.util.ArrayList;
import java.util.List;

import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.struts.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.struts.editors.models.AbstractModel;
import tk.eclipse.plugin.struts.editors.models.ActionMappingsModel;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.ControllerModel;
import tk.eclipse.plugin.struts.editors.models.DataSourceModel;
import tk.eclipse.plugin.struts.editors.models.DataSourcesModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.FormBeanModel;
import tk.eclipse.plugin.struts.editors.models.FormBeansModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionsModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardsModel;
import tk.eclipse.plugin.struts.editors.models.MessageResourcesModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.PluginModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.struts.properties.FormProperties;
import tk.eclipse.plugin.struts.properties.Properties;

/**
 * This is a utility class to generate struts-config.xml from
 * model objects in the visual editor.
 */
public class StrutsConfigModel2XML {
	
	/**
	 * Generates struts-config.xml from RootModel.
	 */
	public static String createStrutsConfig(RootModel root, String extension){
		// Parsing model
		List<AbstractModel> list = root.getChildren();
		
		List<DataSourceModel> dataSources = new ArrayList<DataSourceModel>();
		List<GlobalForwardModel> globalForwards = new ArrayList<GlobalForwardModel>();
		List<GlobalExceptionModel> globalExceptions = new ArrayList<GlobalExceptionModel>();
		List<FormBeanModel> formBeans = new ArrayList<FormBeanModel>();
		List<ActionModel> actionMappings = new ArrayList<ActionModel>();
		List<MessageResourcesModel> messageResources = new ArrayList<MessageResourcesModel>();
		List<PluginModel> plugins = new ArrayList<PluginModel>();
		ControllerModel controller = null;
		
		for(int i=0;i<list.size();i++){
			AbstractModel obj = list.get(i);
			
			if(obj instanceof DataSourceModel){
				dataSources.add((DataSourceModel) obj);
				
			} else if(obj instanceof GlobalForwardModel){
				globalForwards.add((GlobalForwardModel) obj);
				
			} else if(obj instanceof ActionModel){
				actionMappings.add((ActionModel) obj);
				
			} else if(obj instanceof FormBeanModel){
			    formBeans.add((FormBeanModel) obj);
			    
			} else if(obj instanceof ControllerModel){
				controller = (ControllerModel)obj;
				
			} else if(obj instanceof MessageResourcesModel){
				messageResources.add((MessageResourcesModel) obj);
				
			} else if(obj instanceof PluginModel){
				plugins.add((PluginModel) obj);
				
			} else if(obj instanceof GlobalExceptionModel){
				globalExceptions.add((GlobalExceptionModel) obj);
			}
		}
		
		// generate struts-config.xml
		StringBuffer sb = new StringBuffer();
		if(root.getCharset()==null || root.getCharset().length()==0){
			root.setCharset("UTF-8");
		}
		sb.append("<?xml version=\"1.0\" encoding=\"" + root.getCharset() + "\"?>\n");
		sb.append("<!DOCTYPE ").append(root.getDtdName()).append(" PUBLIC ");
		sb.append("\"").append(HTMLUtil.escapeXML(root.getDtdPublicId())).append("\" ");
		sb.append("\"").append(HTMLUtil.escapeXML(root.getDtdSystemId())).append("\">\n");
		
		sb.append(getComment(root.getComment(), ""));
		sb.append("<struts-config");
		sb.append(createAttribute("id",root.getId()));
		sb.append(">\n");
		
		// data-sources
		sb.append(createDataSources(root.getDataSourcesModel(),dataSources));
		// form-bean
		sb.append(createFormBeans(root.getFormBeansModel(),formBeans));
		// global-exceptions
		sb.append(createGlobalExceptions(root.getGlobalExceptionsModel(),globalExceptions));
		// global-forward
		sb.append(createGlobalForwards(root.getGlobalForwardsModel(),globalForwards));
		// action-mapping
		sb.append(createActionMapping(root.getActionMappingsModel(),actionMappings,extension));
		// controller
		sb.append(createController(controller));
		// message-resources
		sb.append(createMessageResources(messageResources));
		// plug-ins
		sb.append(createPlugins(plugins));
		
		sb.append("</struts-config>\n");
		return sb.toString();
	}
	
	private static String createAttribute(String name,String value){
		StringBuffer sb = new StringBuffer();
		if(value!=null && !value.equals("")){
			sb.append(" ").append(name).append("=");
			sb.append("\"").append(HTMLUtil.escapeXML(value)).append("\"");
		}
		return sb.toString();
	}
	
	/** Generates &lt;data-sources&gt;. */
	private static String createDataSources(DataSourcesModel parent,List<DataSourceModel> dataSources){
		StringBuffer sb = new StringBuffer();
		sb.append(getComment(parent.getComment(), "  "));
		sb.append("  <data-sources");
		sb.append(createAttribute("id",parent.getId()));
		sb.append(">\n");
		for(int i=0;i<dataSources.size();i++){
			DataSourceModel model = dataSources.get(i);
			sb.append(getComment(model.getComment(), "    "));
			sb.append("    <data-source");
			sb.append(createAttribute("id",model.getId()));
			sb.append(createAttribute("type",model.getType()));
			sb.append(createAttribute("className",model.getClassName()));
			sb.append(createAttribute("key",model.getKey()));
			Properties props = model.getProperties();
			if(props.size()!=0){
				sb.append(">\n");
				sb.append(createSetProperty(props,6));
				sb.append("    </data-source>\n");
			} else {
				sb.append("/>\n");
			}
		}
		if(sb.toString().trim().equals("<data-sources>")){
			return "";
		}
		sb.append("  </data-sources>\n");
		return sb.toString();
	}
	
	/** Generates &lt;set-property&gt;. */
	private static String createSetProperty(Properties props, int indent){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<props.size();i++){
			for(int j=0;j<indent;j++){
				sb.append(" ");
			}
			String id       = props.getId(i);
			String property = props.getName(i);
			String value    = props.getValue(i);
			sb.append("<set-property");
			sb.append(createAttribute("id",id));
			sb.append(" property=\"").append(HTMLUtil.escapeXML(property)).append("\"").
			   append(" value=\"").append(HTMLUtil.escapeXML(value)).append("\"").append("/>\n");
		}
		return sb.toString();
	}
	
	/** Generats &lt;global-exceptions&gt;. */
	private static String createGlobalExceptions(GlobalExceptionsModel global,List<GlobalExceptionModel> globalExceptions){
		
		StringBuffer sb = new StringBuffer();
		sb.append(getComment(global.getComment(), "  "));
		sb.append("  <global-exceptions");
		sb.append(createAttribute("id",global.getId()));
		sb.append(">\n");
		for(int i=0;i<globalExceptions.size();i++){
			GlobalExceptionModel model = globalExceptions.get(i);
			sb.append(getComment(model.getComment(), "    "));
			sb.append("    <exception");
			sb.append(createAttribute("id",model.getId()));
			sb.append(createAttribute("bundle",model.getBundle()));
			sb.append(createAttribute("type",model.getType()));
			sb.append(createAttribute("path",model.getPath()));
			sb.append(createAttribute("key",model.getKey()));
			sb.append(createAttribute("handler",model.getHandler()));
			sb.append(createAttribute("className",model.getClassName()));
			sb.append(createAttribute("scope",model.getScope()));
			
			Properties props = model.getProperties();
			if(props.size()!=0){
				sb.append(">\n");
				sb.append(createSetProperty(props,6));
				sb.append("    </exception>\n");
			} else {
				sb.append("/>\n");
			}
		}
		
		if(sb.toString().trim().equals("<global-exceptions>")){
			return "";
		}
		
		sb.append("  </global-exceptions>\n");
		return sb.toString();
	}
	
	/** Generats &lt;plug-in&gt;.  */
	private static String createPlugins(List<PluginModel> plugins){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<plugins.size();i++){
			PluginModel model = plugins.get(i);
			sb.append(getComment(model.getComment(), "  "));
			sb.append("  <plug-in");
			sb.append(createAttribute("id",model.getId()));
			sb.append(createAttribute("className",model.getClassName()));
			
			Properties props = model.getProperties();
			if(props.size()!=0){
				sb.append(">\n");
				sb.append(createSetProperty(props,4));
				sb.append("  </plug-in>\n");
			} else {
				sb.append("/>\n");
			}
		}
		return sb.toString();
	}
	
	/** Generates &lt;message-resources&gt; */
	private static String createMessageResources(List<MessageResourcesModel> messageResources){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<messageResources.size();i++){
			MessageResourcesModel model = messageResources.get(i);
			sb.append(getComment(model.getComment(), "  "));
			sb.append("  <message-resources");
			sb.append(createAttribute("id",model.getId()));
			sb.append(createAttribute("parameter",model.getParameter()));
			sb.append(createAttribute("key",model.getKey()));
			sb.append(createAttribute("className",model.getClassName()));
			sb.append(createAttribute("factory",model.getFactory()));
			sb.append(createAttribute("null",model.getNull()));
			
			Properties props = model.getProperties();
			if(props.size()!=0){
				sb.append(">\n");
				sb.append(createSetProperty(props,4));
				sb.append("  </message-resources>\n");
			} else {
				sb.append("/>\n");
			}

		}
		return sb.toString();
	}
	
	/** Generats &lt;controller&gt;. */
	private static String createController(ControllerModel model){
		StringBuffer sb = new StringBuffer();
		sb.append(getComment(model.getComment(), "  "));
		sb.append("  <controller");
		
		if(model!=null){
			sb.append(createAttribute("id",model.getId()));
			sb.append(createAttribute("bufferSize",model.getBufferSize()));
			sb.append(createAttribute("className",model.getClassName()));
			sb.append(createAttribute("contentType",model.getContentType()));
			sb.append(createAttribute("debug",model.getDebug()));
			sb.append(createAttribute("forwardPattern",model.getForwardPattern()));
			sb.append(createAttribute("inputForward",model.getInputForward()));
			sb.append(createAttribute("locale",model.getLocale()));
			sb.append(createAttribute("maxFileSize",model.getMaxFileSize()));
			sb.append(createAttribute("memFileSize",model.getMemFileSize()));
			sb.append(createAttribute("multipartClass",model.getMultipartClass()));
			sb.append(createAttribute("nocache",model.getNocache()));
			sb.append(createAttribute("pagePattern",model.getPagePattern()));
			sb.append(createAttribute("processorClass",model.getProcessorClass()));
			sb.append(createAttribute("tempDir",model.getTempDir()));
		}
		
		if(model==null || model.getProperties().size()==0){
			sb.append("/>\n");
		} else {
			Properties props = model.getProperties();
			sb.append(">\n");
			sb.append(createSetProperty(props,4));
			sb.append("  </controller>\n");
		}
		
		if(sb.toString().trim().equals("<controller>")){
			return "";
		}
		
		return sb.toString();
	}
	
	/** Generates &lt;form-beans&gt;. */
	private static String createFormBeans(FormBeansModel parent, List<FormBeanModel> formBeans){
		StringBuffer sb = new StringBuffer();
		sb.append(getComment(parent.getComment(), "  "));
		sb.append("  <form-beans");
		sb.append(createAttribute("id",parent.getId()));
		sb.append(createAttribute("type",parent.getType()));
		sb.append(">\n");
		for(int i=0;i<formBeans.size();i++){
		    FormBeanModel model = formBeans.get(i);
			sb.append(getComment(model.getComment(), "    "));
		    sb.append("    <form-bean");
		    sb.append(createAttribute("id",model.getId()));
		    sb.append(createAttribute("name",model.getName()));
		    sb.append(createAttribute("type",model.getType()));
		    sb.append(createAttribute("dynamic",model.getDynamic()));
		    sb.append(createAttribute("className",model.getClassName()));
		    
		    FormProperties props = model.getFormProperties();
		    if(props.size()==0){
			    sb.append("/>\n");
		    } else {
		    	sb.append(">\n");
		    	for(int j=0;j<props.size();j++){
		    		String propName      = props.getName(j);
		    		String propType      = props.getType(j);
		    		String propSize      = props.getSize(j);
		    		String propInitial   = props.getInitial(j);
		    		String propClassName = props.getClassName(j);
		    		sb.append("      <form-property")
					  .append(" name=\"").append(HTMLUtil.escapeXML(propName)).append("\"")
	    			  .append(" type=\"").append(HTMLUtil.escapeXML(propType)).append("\"");
		    		sb.append(createAttribute("size",propSize));
		    		sb.append(createAttribute("initial",propInitial));
		    		sb.append(createAttribute("className",propClassName));
		    		
		    		Properties formPropProperties = props.getProperties(j);
		    		if(formPropProperties.size()==0){
		    			sb.append("/>\n");
		    		} else {
		    			sb.append(">\n");
		    			sb.append(createSetProperty(formPropProperties,8));
		    			sb.append("      </form-property>\n");
		    		}
		    	}
		    	sb.append("    </form-bean>\n");
		    }
		}
		
		if(sb.toString().trim().equals("<form-bean>")){
			return "";
		}
		
		sb.append("  </form-beans>\n");
		return sb.toString();
	}
	
	/** Generats &lt;global-forwards&gt;. */
	private static String createGlobalForwards(GlobalForwardsModel global, List<GlobalForwardModel> globalForwards){
		
		StringBuffer sb = new StringBuffer();
		sb.append(getComment(global.getComment(), "  "));
		sb.append("  <global-forwards");
		sb.append(createAttribute("id",global.getId()));
		sb.append(createAttribute("type",global.getType()));
		sb.append(">\n");
		for(int i=0;i<globalForwards.size();i++){
			GlobalForwardModel model = globalForwards.get(i);
			sb.append(getComment(model.getComment(), "    "));
			sb.append("    <forward");
			sb.append(createAttribute("id",model.getId()));
			sb.append(createAttribute("classNAme",model.getClassName()));
			sb.append(createAttribute("name",model.getName()));
			sb.append(createAttribute("path",model.getPath()));
			sb.append(createAttribute("contextRelative",model.getContextRelative()));
			sb.append(createAttribute("redirect",model.getRedirect()));
			
			Properties props = model.getProperties();
			if(props.size()==0){
				sb.append("/>\n");
			} else {
				sb.append(">\n");
				sb.append(createSetProperty(props,6));
				sb.append("    </forward>\n");
			}
		}
		
		if(sb.toString().trim().equals("<global-forwards>")){
			return "";
		}
		
		sb.append("  </global-forwards>\n");
		return sb.toString();
	}
	
	/** Generats &lt;action-mapping&gt;. */
	private static String createActionMapping(ActionMappingsModel mappings, List<ActionModel> actionMappings,String extension){
		
		String mappingsType = mappings.getType();
		
		StringBuffer sb = new StringBuffer();
		sb.append(getComment(mappings.getComment(), "  "));
		sb.append("  <action-mappings");
		if(mappingsType!=null && !mappingsType.equals("")){
			sb.append(" type=\"" + HTMLUtil.escapeXML(mappingsType) + "\"");
		}
		sb.append(">\n");
		for(int i=0;i<actionMappings.size();i++){
			ActionModel model = actionMappings.get(i);
			sb.append(getComment(model.getComment(), "    "));
			sb.append("    <action");
			sb.append(createAttribute("id",model.getId()));
			sb.append(createAttribute("className",model.getClassName()));
            // (MVL) reordered for nicer output: path is most important
            sb.append(createAttribute("path",model.getPath()));
            sb.append(createAttribute("name",model.getName()));
            // (MVL) reordered for nicer output: exactly one of type, forward, include is required
            sb.append(createAttribute("type",model.getType()));
			sb.append(createAttribute("forward",model.getForward()));
            sb.append(createAttribute("include",model.getInclude()));
			sb.append(createAttribute("scope",model.getScope()));
			sb.append(createAttribute("validate",model.getValidate()));
			sb.append(createAttribute("input",model.getInput()));
			sb.append(createAttribute("parameter",model.getParameter()));
			sb.append(createAttribute("prefix",model.getPrefix()));
			sb.append(createAttribute("suffix",model.getSuffix()));
			sb.append(createAttribute("attribute",model.getAttribute()));
			sb.append(createAttribute("roles",model.getRoles()));
			sb.append(createAttribute("unknown",model.getUnknown()));
			sb.append(">\n");
			
			Properties props = model.getProperties();
			if(props.size()!=0){
				sb.append(createSetProperty(props,6));
			}
			
			List<AbstractConnectionModel> conns = model.getModelSourceConnections();
			
			for(int j=0;j<conns.size();j++){
				AbstractConnectionModel conn = conns.get(j);
			    if(conn instanceof ExceptionModel){
			        ExceptionModel arrow = (ExceptionModel) conn;
					String exPath  = null;
					AbstractEntityModel target = arrow.getTarget();
					if(target instanceof ActionModel){
					    exPath = ((ActionModel) target).getPath() + extension;
					} else if(target instanceof PageModel){
					    exPath = ((PageModel) target).getPath();
					}
					sb.append(getComment(arrow.getComment(), "      "));
					sb.append("      <exception");
					sb.append(createAttribute("id",arrow.getId()));
					sb.append(createAttribute("bundle",arrow.getBundle()));
					sb.append(createAttribute("type",arrow.getType()));
					sb.append(createAttribute("key",arrow.getKey()));
					sb.append(createAttribute("scope",arrow.getScope()));
					sb.append(createAttribute("handler",arrow.getHandler()));
					sb.append(createAttribute("className",arrow.getClassName()));
					sb.append(createAttribute("path",exPath));
					
					Properties exProps = arrow.getProperties();
					if(exProps.size()==0){
						sb.append("/>\n");
					} else {
						sb.append(">\n");
						sb.append(createSetProperty(exProps,8));
						sb.append("      </exception>\n");
					}
			    }
			}
			for(int j=0;j<conns.size();j++){
			    Object obj = conns.get(j);
			    if(obj instanceof ForwardModel){
					ForwardModel arrow = (ForwardModel)obj;
					String fwPath = null;
					AbstractEntityModel target = arrow.getTarget();
					if(arrow.getTargetName()!=null){
						fwPath = arrow.getTargetName();
					} else if(target instanceof ActionModel){
					    fwPath = ((ActionModel)target).getPath() + extension;
					} else if(target instanceof PageModel){
					    fwPath = ((PageModel)target).getPath();
					}
					sb.append(getComment(arrow.getComment(), "      "));
					sb.append("      <forward");
					sb.append(createAttribute("id",arrow.getId()));
					sb.append(createAttribute("name",arrow.getName()));
					sb.append(createAttribute("className",arrow.getClassName()));
					sb.append(createAttribute("contextRelative",arrow.getContextRelative()));
					sb.append(createAttribute("redirect",arrow.getRedirect()));
					sb.append(createAttribute("path",fwPath));
					
					Properties fwProps = arrow.getProperties();
					if(fwProps.size()==0){
						sb.append("/>\n");
					} else {
						sb.append(">\n");
						sb.append(createSetProperty(fwProps,8));
						sb.append("      </forward>\n");
					}
			    }
			}
			
			sb.append("    </action>\n");
		}
		
		if(sb.toString().trim().equals("<action-mappings>")){
			return "";
		}
		
		sb.append("  </action-mappings>\n");
		return sb.toString();
	}
	
	private static String getComment(String value, String indent){
		if(value==null || value.trim().length()==0){
			return "";
		}
		
		value = value.trim();
		
		if(value.indexOf('\r')>0 || value.indexOf('\n')>0){
			value = value.replaceAll("\r\n", "\n");
			value = value.replaceAll("\n", "\n");
			value = value.replaceAll("\n", "\n" + indent);
			return indent + "<!--\n" + indent + value + "\n" + indent + "-->\n";
		}
		
		return indent + "<!-- " + value + " -->\n";
	}
}
