package tk.eclipse.plugin.struts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

import tk.eclipse.plugin.struts.editors.ConnectoinBendpoint;
import tk.eclipse.plugin.struts.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.struts.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.struts.editors.models.ActionMappingsModel;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.ControllerModel;
import tk.eclipse.plugin.struts.editors.models.DataSourceModel;
import tk.eclipse.plugin.struts.editors.models.DataSourcesModel;
import tk.eclipse.plugin.struts.editors.models.DirectForwardModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.FormBeanModel;
import tk.eclipse.plugin.struts.editors.models.FormBeansModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionsModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardsModel;
import tk.eclipse.plugin.struts.editors.models.IncludeModel;
import tk.eclipse.plugin.struts.editors.models.InputModel;
import tk.eclipse.plugin.struts.editors.models.MessageResourcesModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.PluginModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.struts.properties.FormProperties;
import tk.eclipse.plugin.struts.properties.Properties;

/**
 * This handler builds model objects from struts-config.xml.
 * And it also validates attribute values and creates error markers.
 * 
 * @author Naoki Takezoe
 */
public class StrutsConfigSAXHandler extends DefaultHandler implements LexicalHandler {
	
	private RootModel root;
	private Stack<Object> stack = new Stack<Object>();
	private Map<String, PageModel> pages   = new HashMap<String, PageModel>();
	private Map<String, ActionModel> actions = new HashMap<String, ActionModel>();
	private List<Object[]> actionForwards = new ArrayList<Object[]>();
	private List<AbstractEntityModel> oldModels;
	private String extension;
	private StringBuffer comment = new StringBuffer();
	
	private boolean controller = false;
	
	/**
	 * Constructor.
	 * 
	 * @param resource  IResource of struts-config.xml
	 * @param oldModels Old RootModel
	 */
	public StrutsConfigSAXHandler(IResource resource, List<AbstractEntityModel> oldModels){
		this.root = new RootModel();
		this.oldModels = oldModels;
		
		StrutsProject strutsProject = new StrutsProject(resource.getProject());
		this.extension = strutsProject.getExtension();
	}
	
	private Object getPrevObject(){
		if(stack.size()==0){
			return null;
		} else {
			return stack.get(stack.size()-1);
		}
	}
	
	public void endDocument() throws SAXException {
		for(int i=0;i<actionForwards.size();i++){
			Object[] obj = (Object[]) actionForwards.get(i);
			String path = (String)obj[0];
			AbstractConnectionModel model = (AbstractConnectionModel) obj[1];
			
			if(path.indexOf('?')>=0){
				model.setTargetName(path);
				path = path.substring(0, path.indexOf('?'));
			}
			
			AbstractEntityModel target = (AbstractEntityModel)actions.get(path);
			if(target!=null){
                if (model instanceof InputModel) {
                    model.setSource(target);
                    model.attachSource();
                } else {
                    model.setTarget(target);
                    model.attachTarget();
                }
			}
//			else {
//			    System.out.print("");
//            }
		}
		if(!controller){
			ControllerModel model = new ControllerModel();
			root.addChild(model);
		}
	}
	
	public void startElement(String uri, String localName, String qName,Attributes attributes) throws SAXException {
		if(qName.equals("action")){
			handleAction(attributes);
		} else if(qName.equals("forward")){
			handleForward(attributes);
		} else if(qName.equals("global-forwards")){
			handleGlobalForwards(attributes);
		} else if(qName.equals("form-bean")){
			handleFormBean(attributes);
		} else if(qName.equals("controller")){
			handleController(attributes);
		} else if(qName.equals("message-resources")){
			handleMessageResources(attributes);
		} else if(qName.equals("plug-in")){
			handlePlugin(attributes);
		} else if(qName.equals("set-property")){
			handleSetProperty(attributes);
		} else if(qName.equals("global-exceptions")){
			handleGlobalExceptions(attributes);
		} else if(qName.equals("exception")){
			handleException(attributes);
		} else if(qName.equals("data-source")){
			handleDataSource(attributes);
		} else if(qName.equals("form-property")){
			handleFormProperty(attributes);
		} else if(qName.equals("action-mappings")){
			handleActionMappings(attributes);
		} else if(qName.equals("data-sources")){
			handleDataSources(attributes);
		} else if(qName.equals("form-beans")){
			handleFormBeans(attributes);
		} else if(qName.equals("struts-config")){
			handlerStrutsConfig(attributes);
		}
		comment.setLength(0);
	}
	
	public void endElement(String uri, String localName, String qName) throws SAXException {
		if(qName.equals("action")){
			handleAction(null);
		} else if(qName.equals("forward")){
			handleForward(null);
		} else if(qName.equals("global-forwards")){
			handleGlobalForwards(null);
		} else if(qName.equals("form-bean")){
			handleFormBean(null);
		} else if(qName.equals("controller")){
			handleController(null);
		} else if(qName.equals("message-resources")){
			handleMessageResources(null);
		} else if(qName.equals("plug-in")){
			handlePlugin(null);
		} else if(qName.equals("set-property")){
			handleSetProperty(null);
		} else if(qName.equals("global-exceptions")){
			handleGlobalExceptions(null);
		} else if(qName.equals("exception")){
			handleException(null);
		} else if(qName.equals("data-source")){
			handleDataSource(null);
		} else if(qName.equals("form-property")){
			handleFormProperty(null);
		} else if(qName.equals("action-mappings")){
			handleActionMappings(null);
		} else if(qName.equals("data-sources")){
			handleDataSources(null);
		} else if(qName.equals("form-beans")){
			handleFormBeans(null);
		} else if(qName.equals("struts-config")){
			handlerStrutsConfig(null);
		}
	}
	
	private int actionCount = 0;
	private int pageCount   = 0;
	
	/**
	 * Returns a constraint (size and location) of a visual model.
	 * 
	 * @param model entity model
	 * @return Rectangle constraint
	 */
	private Rectangle getConstraint(AbstractEntityModel model){
		for(int i=0;i<oldModels.size();i++){
			Object obj = oldModels.get(i);
			if(obj.equals(model)){
				return ((AbstractEntityModel)obj).getConstraint();
			}
		}
		if(model instanceof ActionModel){
			actionCount++;
			return new Rectangle(100,(actionCount-1) * 64,-1,-1);
		} else if(model instanceof PageModel){
			pageCount++;
			return new Rectangle(300,(pageCount-1) * 64,-1,-1);
		}
		return null;
	}
	
	/**
	 * Returns bend-points of a connection model.
	 * 
	 * @param model connection model
	 * @return a list of bend-points
	 */
	private List<ConnectoinBendpoint> getBendpoints(AbstractConnectionModel model){
		for(int i=0;i<oldModels.size();i++){
			Object obj = oldModels.get(i);
			if(obj instanceof ActionModel){
                List<AbstractConnectionModel> conns = ((ActionModel) obj).getModelSourceConnections();
                if (model instanceof InputModel) {
                    conns = ((ActionModel) obj).getModelTargetConnections();
                }
				for(int j=0;j<conns.size();j++){
					Object conn = conns.get(j);
					if(conn.equals(model)){
						return ((AbstractConnectionModel) conn).getBendpoints();
					}
				}
			}
		}
		return null;
	}
    
    // (MVL) added
    private void addBendPoints(AbstractConnectionModel model) {
        List<ConnectoinBendpoint> bendpoints = getBendpoints(model);
        if(bendpoints!=null){
            for(int i=0;i<bendpoints.size();i++){
                model.addBendpoint(i, bendpoints.get(i));
            }
        }
    }
    
    // (MVL) added
    private AbstractEntityModel getPage(String path) {
        if (path == null || Util.getNoQueryPath(path).endsWith(extension)) {
            return null;
        } else if (pages.get(path)!=null){
            AbstractEntityModel page = (AbstractEntityModel) pages.get(path);
            return page;
        } else {
            PageModel page = new PageModel();
            page.setPath(path);
            pages.put(path, page);
            page.setConstraint(getConstraint(page));
            root.addChild(page);
            return page;
        }
    }
	
	/**
	 * Process &lt;struts-config&gt;.
	 */
	private void handlerStrutsConfig(Attributes attributes){
		if(attributes==null){
			return;
		}
		String id = attributes.getValue("id");
		if(id!=null){
			root.setId(id);
		}
		root.setComment(comment.toString().trim());
	}
	
	/**
	 * Process &lt;form-beans&gt;.
	 */
	private void handleFormBeans(Attributes attributes){
		if(attributes==null){
			return;
		}
		String id   = attributes.getValue("id");
		String type = attributes.getValue("type");
		FormBeansModel model = root.getFormBeansModel();
		if(id!=null){
			model.setId(id);
		}
		if(type!=null){
			model.setType(type);
		}
		model.setComment(comment.toString().trim());
	}
	
	/**
	 * Process &lt;data-sources&gt;.
	 */
	private void handleDataSources(Attributes attributes){
		if(attributes==null){
			return;
		}
		String id = attributes.getValue("id");
		DataSourcesModel model = root.getDataSourcesModel();
		if(id!=null){
			model.setId(id);
		}
		model.setComment(comment.toString().trim());
	}
	
	/**
	 * Process &lt;form-property&gt;.
	 */
	private void handleFormProperty(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		
		String name      = attributes.getValue("name");
		String type      = attributes.getValue("type");
		String size      = attributes.getValue("size");
		String initial   = attributes.getValue("initial");
		String className = attributes.getValue("className");
		
		if(name==null){
			name = "";
		}
		if(type==null){
			type = "";
		}
		if(size==null){
			size = "";
		}
		if(initial==null){
			initial = "";
		}
		if(className==null){
			className = "";
		}
		
		Object prevObj = getPrevObject();
		FormProperties model = ((FormBeanModel) prevObj).getFormProperties();
		model.addProperty(name, type, size, initial, className, new Properties());
		stack.push(model);
	}
	
	/** 
	 * Process &lt;data-source&gt;.
	 */
	private void handleDataSource(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		
		String id        = attributes.getValue("id");
		String type      = attributes.getValue("type");
		String className = attributes.getValue("className");
		String key       = attributes.getValue("key");
		
		DataSourceModel model = new DataSourceModel();
		if(id!=null){
			model.setId(id);
		}
		if(type!=null){
			model.setType(type);
		}
		if(className!=null){
			model.setClassName(className);
		}
		if(key!=null){
			model.setKey(key);
		}
		model.setComment(comment.toString().trim());
		
		root.addChild(model);
		stack.push(model);
	}
	
	/**
	 * Process &lt;exception&gt;.
	 */
	private void handleException(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		
		String id        = attributes.getValue("id");
		String bundle    = attributes.getValue("bundle");
		String type      = attributes.getValue("type");
		String path      = attributes.getValue("path");
		String key       = attributes.getValue("key");
		String className = attributes.getValue("className");
		String handler   = attributes.getValue("handler");
		String scope     = attributes.getValue("scope");
		
		Object prevObj = getPrevObject();
		
		if(prevObj instanceof ActionModel){
			ExceptionModel model = new ExceptionModel();
			model.setComment(comment.toString().trim());
			if(id!=null){
				model.setId(id);
			}
			if(bundle!=null){
				model.setBundle(bundle);
			}
			if(type!=null){
				model.setType(type);
			}
			if(key!=null){
				model.setKey(key);
			}
			if(className!=null){
				model.setClassName(className);
			}
			if(scope!=null){
				model.setScope(scope);
			}
			if(handler!=null){
				model.setHandler(handler);
			}
			if(path!=null){
				// remove query string
                // (MVL) simplified
                AbstractEntityModel page = getPage(path);
                if (page != null) {
                    model.setTarget(page);
                    model.attachTarget();
				} else {
					actionForwards.add(new Object[]{path,model});
				}
			}
			if(prevObj!=null){
				model.setSource((AbstractEntityModel)prevObj);
				model.attachSource();
				// restore bend-points 
                // (MVL) simplified
                addBendPoints(model);
			}
			stack.push(model);
			
		} else if(prevObj.equals("global-exceptions")){
			GlobalExceptionModel model = new GlobalExceptionModel();
			model.setComment(comment.toString().trim());
			if(id!=null){
				model.setId(id);
			}
			if(bundle!=null){
				model.setBundle(bundle);
			}
			if(type!=null){
				model.setType(type);
			}
			if(path!=null){
				model.setPath(path);
			}
			if(key!=null){
				model.setKey(key);
			}
			if(className!=null){
				model.setClassName(className);
			}
			if(scope!=null){
				model.setScope(scope);
			}
			if(handler!=null){
				model.setHandler(handler);
			}
			root.addChild(model);
            // (MVL) simplified: create page, if not existing yet
            getPage(path);
			stack.push(model);
		}
	}
	
	/**
	 * Process &lt;set-property&gt;.
	 */
	private void handleSetProperty(Attributes attributes){
		if(attributes==null){
			return;
		}
		
		String id       = attributes.getValue("id");
		String property = attributes.getValue("property");
		String value    = attributes.getValue("value");
		
		if(id==null){
			id = "";
		}
		if(property==null){
			property = "";
		}
		if(value==null){
			value = "";
		}
		
		Object prevObj = getPrevObject();
		
		if(prevObj instanceof PluginModel){
			((PluginModel)prevObj).getProperties().addProperty(property,value,id);
		} else if(prevObj instanceof DataSourceModel){
			((DataSourceModel)prevObj).getProperties().addProperty(property,value,id);
		} else if(prevObj instanceof ControllerModel){
			((ControllerModel)prevObj).getProperties().addProperty(property,value,id);
		} else if(prevObj instanceof MessageResourcesModel){
			((MessageResourcesModel)prevObj).getProperties().addProperty(property,value,id);
		} else if(prevObj instanceof ExceptionModel){
			((ExceptionModel)prevObj).getProperties().addProperty(property,value,id);
		} else if(prevObj instanceof ActionModel){
			((ActionModel)prevObj).getProperties().addProperty(property,value,id);
		} else if(prevObj instanceof ForwardModel){
			((ForwardModel)prevObj).getProperties().addProperty(property,value,id);
		} else if(prevObj instanceof GlobalForwardModel){
			((GlobalForwardModel)prevObj).getProperties().addProperty(property,value,id);
		} else if(prevObj instanceof GlobalExceptionModel){
			((GlobalExceptionModel)prevObj).getProperties().addProperty(property,value,id);
		} else if(prevObj instanceof FormProperties){
			FormProperties formProps = (FormProperties)prevObj;
			formProps.getProperties(formProps.size()-1).addProperty(property,value,id);
		}
	}
	
	/**
	 * Process &lt;plug-in&gt;.
	 */
	private void handlePlugin(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		PluginModel model = new PluginModel();
		String id        = attributes.getValue("id");
		String className = attributes.getValue("className");
		if(id!=null){
			model.setId(id);
		}
		if(className!=null){
			model.setClassName(className);
		}
		model.setComment(comment.toString().trim());
		root.addChild(model);
		stack.push(model);
	}
	
	/**
	 * Process &lt;message-resources&gt;.
	 */
	private void handleMessageResources(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		MessageResourcesModel model = new MessageResourcesModel();
		String id        = attributes.getValue("id");
		String parameter = attributes.getValue("parameter");
		String key       = attributes.getValue("key");
		String className = attributes.getValue("className");
		String factory   = attributes.getValue("factory");
		String nullVal   = attributes.getValue("null");
		if(id!=null){
			model.setId(id);
		}
		if(parameter!=null){
			model.setParameter(parameter);
		}
		if(key!=null){
			model.setKey(key);
		}
		if(className!=null){
			model.setClassName(className);
		}
		if(factory!=null){
			model.setFactory(factory);
		}
		if(nullVal!=null){
			model.setNull(nullVal);
		}
		model.setComment(comment.toString().trim());
		root.addChild(model);
		stack.push(model);
	}
	
	/**
	 * Process &lt;controller&gt;.
	 */
	private void handleController(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		ControllerModel model = new ControllerModel();
		String id             = attributes.getValue("id");
		String bufferSize     = attributes.getValue("bufferSize");
		String className      = attributes.getValue("className");
		String contentType    = attributes.getValue("contentType");
		String debug          = attributes.getValue("debug");
		String forwardPattern = attributes.getValue("forwardPattern");
		String inputForward   = attributes.getValue("inputForward");
		String locale         = attributes.getValue("locale");
		String maxFileSize    = attributes.getValue("maxFileSize");
		String memFileSize    = attributes.getValue("memFileSize");
		String multipartClass = attributes.getValue("multipartClass");
		String nocache        = attributes.getValue("nocache");
		String pagePattern    = attributes.getValue("pagePattern");
		String processorClass = attributes.getValue("processorClass");
		String tempDir        = attributes.getValue("tempDir");
		if(id!=null){
			model.setId(id);
		}
		if(bufferSize!=null){
			model.setBufferSize(bufferSize);
		}
		if(className!=null){
			model.setClassName(className);
		}
		if(contentType!=null){
			model.setContentType(contentType);
		}
		if(debug!=null){
			model.setId(debug);
		}
		if(forwardPattern!=null){
			model.setForwardPattern(forwardPattern);
		}
		if(inputForward!=null){
			model.setInputForward(inputForward);
		}
		if(locale!=null){
			model.setLocale(locale);
		}
		if(maxFileSize!=null){
			model.setMaxFileSize(maxFileSize);
		}
		if(memFileSize!=null){
			model.setId(memFileSize);
		}
		if(multipartClass!=null){
			model.setMultipartClass(multipartClass);
		}
		if(nocache!=null){
			model.setNocache(nocache);
		}
		if(pagePattern!=null){
			model.setPagePattern(pagePattern);
		}
		if(processorClass!=null){
			model.setProcessorClass(processorClass);
		}
		if(tempDir!=null){
			model.setTempDir(tempDir);
		}
		model.setComment(comment.toString().trim());
		root.addChild(model);
		controller = true;
		stack.push(model);
	}
	
	/** 
	 * Process &lt;action&gt;.
	 */
	private void handleAction(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		ActionModel model = new ActionModel();
		String id        = attributes.getValue("id");
		String className = attributes.getValue("className");
		String forward   = attributes.getValue("forward");
		String path      = attributes.getValue("path");
		String type      = attributes.getValue("type");
		String input     = attributes.getValue("input");
		String name      = attributes.getValue("name");
		String scope     = attributes.getValue("scope");
		String validate  = attributes.getValue("validate");
		String parameter = attributes.getValue("parameter");
		String include   = attributes.getValue("include");
		String prefix    = attributes.getValue("prefix");
		String suffix    = attributes.getValue("suffix");
		String attribute = attributes.getValue("attribute");
		String roles     = attributes.getValue("roles");
		String unknown   = attributes.getValue("unknown");
		if(id!=null){
			model.setId(id);
		}
		if(className!=null){
			model.setClassName(className);
		}
		if(path!=null){
			model.setPath(path);
		}
		if(type!=null){
			model.setType(type);
		}
		if(name!=null){
			model.setName(name);
		}
		if(scope!=null){
			model.setScope(scope);
		}
		if(validate!=null){
			model.setValidate(validate);
		}
		if(parameter!=null){
			model.setParameter(parameter);
		}
		if(prefix!=null){
			model.setPrefix(prefix);
		}
		if(suffix!=null){
			model.setSuffix(suffix);
		}
		if(attribute!=null){
			model.setAttribute(attribute);
		}
		if(roles!=null){
			model.setRoles(roles);
		}
		if(unknown!=null){
			model.setUnknown(unknown);
		}
        // (MVL) moved connections to end
        if(forward!=null){
            // (MVL) create connection instead of filling attribute
            DirectForwardModel forwardModel = new DirectForwardModel();
            AbstractEntityModel page = getPage(forward);
            if (page != null) {
                forwardModel.setTarget(page);
                forwardModel.attachTarget();
            } else {
                actionForwards.add(new Object[] { forward, forwardModel });
            }
            forwardModel.setSource(model);
            forwardModel.attachSource();
            addBendPoints(forwardModel);
        }
        if(include!=null){
            // (MVL) create connection instead of filling attribute
            IncludeModel includeModel = new IncludeModel();
            AbstractEntityModel page = getPage(include);
            if (page != null) {
                includeModel.setTarget(page);
                includeModel.attachTarget();
            } else {
                actionForwards.add(new Object[] { include, includeModel });
            }
            includeModel.setSource(model);
            includeModel.attachSource();
            addBendPoints(includeModel);
        }
        if(input!=null){
            // (MVL) create connection instead of filling attribute
            InputModel inputModel = new InputModel();
            AbstractEntityModel page = getPage(input);
            if (page != null) {
                inputModel.setSource(page);
                inputModel.attachSource();
            } else {
                actionForwards.add(new Object[] { input, inputModel });
            }
            inputModel.setTarget(model);
            inputModel.attachTarget();
            addBendPoints(inputModel);
        }
		model.setConstraint(getConstraint(model));
		model.setComment(comment.toString().trim());
		root.addChild(model);
		stack.push(model);
		actions.put(path + extension, model);
	}
	
	/**
	 * Process &lt;forward&gt;.
	 */
	private void handleForward(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		String id              = attributes.getValue("id");
		String name            = attributes.getValue("name");
		String path            = attributes.getValue("path");
		String className       = attributes.getValue("className");
		String contextRelative = attributes.getValue("contextRelative");
		String redirect        = attributes.getValue("redirect");
		
		Object prevObj = getPrevObject();
		
		if(prevObj.equals("global-forwards")){
			GlobalForwardModel model = new GlobalForwardModel();
			model.setComment(comment.toString().trim());
			if(name!=null){
				model.setName(name);
			}
			if(path!=null){
				model.setPath(path);
			}
			if(className!=null){
				model.setClassName(className);
			}
			if(id!=null){
				model.setId(id);
			}
			if(contextRelative!=null){
				model.setContextRelative(contextRelative);
			}
			if(redirect!=null){
				model.setRedirect(redirect);
			}
			root.addChild(model);
            // (MVL) simplified
            getPage(path);
			stack.push(model);
			return;
		}
		
		ForwardModel model = new ForwardModel();
		model.setComment(comment.toString().trim());
		if(name!=null){
			model.setName(name);
		}
		if(className!=null){
			model.setClassName(className);
		}
		if(id!=null){
			model.setId(id);
		}
		if(contextRelative!=null){
			model.setContextRelative(contextRelative);
		}
		if(redirect!=null){
			model.setRedirect(redirect);
		}
		if(path!=null){
            // (MVL) simplified
            AbstractEntityModel page = getPage(path);
			if (page != null){
				model.setTarget(page);
				model.attachTarget();
			} else {
				actionForwards.add(new Object[]{path,model});
			}
		}
		if(prevObj!=null){
			model.setSource((AbstractEntityModel)prevObj);
			model.attachSource();
            // (MVL) simplified
            addBendPoints(model);
		}
		stack.push(model);
	}
	
	/**
	 * Process &lt;global-forwards&gt;.
	 */
	private void handleGlobalForwards(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		stack.push("global-forwards");
		String type = attributes.getValue("type");
		String id   = attributes.getValue("id");
		GlobalForwardsModel model = root.getGlobalForwardsModel();
		if(type!=null){
			model.setType(type);
		}
		if(id!=null){
			model.setId(id);
		}
		model.setComment(comment.toString().trim());
	}
	
	/**
	 * Process &lt;global-exceptions&gt;.
	 */
	private void handleGlobalExceptions(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		stack.push("global-exceptions");
		String id = attributes.getValue("id");
		GlobalExceptionsModel model = root.getGlobalExceptionsModel();
		if(id!=null){
			model.setId(id);
		}
		model.setComment(comment.toString().trim());
	}
	
	/**
	 * Process &lt;action-mappings&gt;.
	 */
	private void handleActionMappings(Attributes attributes){
		if(attributes==null){
			return;
		}
		String type = attributes.getValue("type");
		ActionMappingsModel model = root.getActionMappingsModel();
		if(type!=null){
			model.setType(type);
		}
		model.setComment(comment.toString().trim());
	}
	
	/**
	 * Process &lt;form-bean&gt;.
	 */
	private void handleFormBean(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		FormBeanModel model = new FormBeanModel();
		String id        = attributes.getValue("id");
		String name      = attributes.getValue("name");
		String type      = attributes.getValue("type");
		String dynamic   = attributes.getValue("dynamic");
		String className = attributes.getValue("className");
		if(id!=null){
			model.setId(id);
		}
		if(name!=null){
			model.setName(name);
		}
		if(type!=null){
			model.setType(type);
		}
		if(dynamic!=null){
			model.setDynamic(dynamic);
		}
		if(className!=null){
			model.setClassName(className);
		}
		model.setComment(comment.toString().trim());
		root.addChild(model);
		stack.push(model);
	}
	
	/**
	 * Returns RootModel builded by struts-config.xml.
	 * 
	 * @return RootModel
	 */
	public RootModel getModel(){
		return root;
	}
	
	public void comment(char[] ch, int start, int length) throws SAXException {
		comment.append(new String(ch, start, length));
	}
	
	public void endCDATA() throws SAXException {
		comment.setLength(0);
	}
	
	public void endDTD() throws SAXException {
		comment.setLength(0);
	}
	
	public void endEntity(String name) throws SAXException {
		comment.setLength(0);
	}
	
	public void startCDATA() throws SAXException {
	}
	
	public void startDTD(String name, String publicId, String systemId) throws SAXException {
		root.setDtdName(name);
		root.setDtdPublicId(publicId);
		root.setDtdSystemId(systemId);
	}
	
	public void startEntity(String name) throws SAXException {
	}
}
