package tk.eclipse.plugin.struts;

import java.io.InputStream;
import java.util.List;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.eclipse.core.resources.IFile;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

import tk.eclipse.plugin.struts.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

/**
 * A utility class to generate model objects from struts-config.xml (XML documnt).
 * This uses SAX parsing, but processing is fuzzy.
 * 
 * @author Naoki Takezoe
 */
public class StrutsConfigXML2Model {
	
	/**
	 * Generates RootModel from struts-config.xml.
	 * 
	 * @param in InputStream of struts-config.xml
	 * @param oldModel Old RootModel
	 * @param resource IFile of struts-config.xml
	 */
	public static RootModel createModel(InputStream in, RootModel oldModel, IFile resource){
		StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
		try {
			if(oldModel!=null){
				List<AbstractEntityModel> oldModels = oldModel.getViasualChildren();
				
				SAXParserFactory spfactory = SAXParserFactory.newInstance();
				spfactory.setValidating(false);
				SAXParser parser = spfactory.newSAXParser();
				XMLReader reader = parser.getXMLReader(); 
				
				StrutsConfigSAXHandler handler = new StrutsConfigSAXHandler(resource, oldModels);
				
				reader.setEntityResolver(new StrutsConfigResolver());
				reader.setContentHandler(handler);
				reader.setProperty("http://xml.org/sax/properties/lexical-handler",handler);
				reader.parse(new InputSource(in));
				
				RootModel root = handler.getModel();
				root.setCharset(resource.getCharset());
				if(root.getCharset()==null || root.getCharset().length()==0){
					root.setCharset("UTF-8");
				}
				
				return root;
			}
		} catch(Exception ex){
			Util.logException(ex);
		} finally {
			StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
		}
		return new RootModel();
	}
}
