package tk.eclipse.plugin.struts;

import java.util.HashMap;
import java.util.Map;

import tk.eclipse.plugin.htmleditor.ICustomTagConverter;
import tk.eclipse.plugin.htmleditor.ICustomTagConverterContributer;
import tk.eclipse.plugin.jspeditor.converters.HTMLConverter;

/**
 * @author takezoe
 */
public class StrutsHTMLCustomTagConverterContributer implements ICustomTagConverterContributer {
	
	private Map<String, ICustomTagConverter> map = new HashMap<String, ICustomTagConverter>();
	
	public StrutsHTMLCustomTagConverterContributer(){
		map.put("html"     ,new HTMLConverter("html"));
		map.put("form"     ,new HTMLConverter("form"));
		map.put("button"   ,new HTMLConverter("input type=\"button\""));
		map.put("submit"   ,new HTMLConverter("input type=\"submit\""));
		map.put("cancel"   ,new HTMLConverter("input type=\"submit\""));
		map.put("reset"    ,new HTMLConverter("input type=\"reset\""));
		map.put("text"     ,new HTMLConverter("input type=\"text\""));
		map.put("password" ,new HTMLConverter("input type=\"password\""));
		map.put("textarea" ,new HTMLConverter("textarea"));
		map.put("hidden"   ,new HTMLConverter("input type=\"hidden\""));
		map.put("checkbox" ,new HTMLConverter("input type=\"checkbox\""));
		map.put("multibox" ,new HTMLConverter("input type=\"checkbox\""));
		map.put("radio"    ,new HTMLConverter("input type=\"radio\""));
		map.put("image"    ,new HTMLConverter("input type=\"image\""));
		map.put("select"   ,new HTMLConverter("select"));
		map.put("option"   ,new HTMLConverter("option"));
		map.put("options"  ,new HTMLConverter("option")); // TODO Hmm...
		map.put("optionsCollection",new HTMLConverter("option")); // TODO Hmm...
		map.put("link"     ,new HTMLConverter("a"));
		map.put("img"      ,new HTMLConverter("img"));
		map.put("file"     ,new HTMLConverter("input type=\"file\""));
		// TODO frameH
	}
	
	public ICustomTagConverter getConverter(String tagName) {
		return map.get(tagName);
	}
	
}
