package tk.eclipse.plugin.struts;

import java.util.Stack;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

import tk.eclipse.plugin.struts.editors.models.TilesAttributeModel;
import tk.eclipse.plugin.struts.editors.models.TilesDefinitionModel;
import tk.eclipse.plugin.struts.editors.models.TilesRootModel;

/**
 * This handler builds model objects from struts-config.xml.
 * And it also validates attribute values and creates error markers.
 * 
 * @author Naoki Takezoe
 */
public class TilesDefsSAXHandler extends DefaultHandler implements LexicalHandler {
	
	private TilesRootModel root = new TilesRootModel();
	private Stack stack = new Stack();
	
	/**
	 * Constructor.
	 * 
	 * @param resource  IResource of struts-config.xml
	 * @param oldModels Old RootModel
	 */
	public TilesDefsSAXHandler(){
	}
	
	private Object getPrevObject(){
		if(stack.size()==0){
			return null;
		} else {
			return stack.get(stack.size()-1);
		}
	}
	
	public void endDocument() throws SAXException {
	}
	
	public void startElement(String uri, String localName, String qName,Attributes attributes) throws SAXException {
		if(qName.equals("definition")){
			handleDefinition(attributes);
		} else if(qName.equals("put")){
			handlePut(attributes);
		}
	}
	
	public void endElement(String uri, String localName, String qName) throws SAXException {
		if(qName.equals("definition")){
			handleDefinition(null);
		} else if(qName.equals("put")){
			handlePut(null);
		}
	}
	
	/**
	 * Process &lt;definition&gt;.
	 */
	private void handleDefinition(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		
		String name = attributes.getValue("name");
		String path = attributes.getValue("path");
        if (path == null) path = attributes.getValue("page");     // pseudonym for path
        if (path == null) path = attributes.getValue("template"); // pseudonym for path
        String extendedDefinitionName = attributes.getValue("extends");
        // all other attributes ignored
        TilesDefinitionModel extendedDefinition = null;
        if (extendedDefinitionName != null) {
            extendedDefinition = root.getDefinition(extendedDefinitionName);
            if (extendedDefinition == null) {
                extendedDefinition = new TilesDefinitionModel();
                extendedDefinition.setName(extendedDefinitionName);
                root.addDefinition(extendedDefinition);
            }
        }
        
        TilesDefinitionModel model = root.getDefinition(name);
        if (model == null) {
            model = new TilesDefinitionModel();
            model.setName(name);
            root.addDefinition(model);
        }
        model.setPath(path);
        model.setExtendedDefinition(extendedDefinition);
		stack.push(model);
	}
	
	/** 
	 * Process &lt;put&gt;.
	 */
	private void handlePut(Attributes attributes){
		if(attributes==null){
			stack.pop();
			return;
		}
		
		String name = attributes.getValue("name");
        String value = attributes.getValue("value");
        if (value == null) value = attributes.getValue("content"); // pseudonym for value
        String type = attributes.getValue("type");
        if (type == null) {
            // direct="true" is the same as type="string"
            if (Boolean.valueOf(attributes.getValue("direct")).booleanValue()) type = "string";
        }

        TilesAttributeModel model = new TilesAttributeModel();
        model.setName(name);
        model.setValue(value);
        model.setType(type);
        TilesDefinitionModel definition = (TilesDefinitionModel) getPrevObject();
        definition.addAttribute(model);
		stack.push(model);
	}
	
	/**
	 * Returns RootModel builded by tiles-defs.xml.
	 * 
	 * @return RootModel
	 */
	public TilesRootModel getModel(){
		return root;
	}
	
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }
    
    public void endDTD() throws SAXException {
    }
    
    public void startEntity(String name) throws SAXException {
    }
    
    public void endEntity(String name) throws SAXException {
    }

	public void comment(char[] ch, int start, int length) throws SAXException {
	}
	
    public void startCDATA() throws SAXException {
    }
    
	public void endCDATA() throws SAXException {
	}
	
}
