package tk.eclipse.plugin.struts;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.editors.models.AbstractModel;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.struts.wizards.ActionFormWizard;
import tk.eclipse.plugin.struts.wizards.ActionWizard;
import tk.eclipse.plugin.struts.wizards.JSPWizard;

/**
 * This class provides utility methods.
 * 
 * @author Naoki Takezoe
 */
public class Util {
	
	/**
	 * Returns a matched index in the string array.
	 * If no matches, returns zero.
	 * 
	 * @param array the string array which will be searched
	 * @param value the search string
	 * @return matched index
	 */
	public static int getIndex(String[] array,String value){
		for(int i=0;i<array.length;i++){
			if(array[i].equals(value)){
				return i;
			}
		}
		return 0;
	}

	/**
	 * Returns an extracted list filtered by an extract type from a source list .
	 * 
	 * @param list  source list
	 * @param clazz extract type
	 * @return extracted list
	 */
	public static <T> List<T> filtering(List<T> list,Class<?> clazz){
		List<T> result = new ArrayList<T>();
		for(int i=0;i<list.size();i++){
			T obj = list.get(i);
			if(clazz.isInstance(obj)){
				result.add(obj);
			}
		}
		return result;
	}
	
	/**
	 * Opens the JSP creation wizard.
	 * 
	 * @param container parent container
	 * @param fileName  filename
	 */
	public static void openJSPWizard(Object container,String fileName){
		JSPWizard wizard = new JSPWizard();
		wizard.init(PlatformUI.getWorkbench(),new StructuredSelection(container));
		wizard.setFileName(getNoQueryPath(fileName));
//		Shell shell = Display.getCurrent().getActiveShell();
		WizardDialog dialog = new WizardDialog(null,wizard);
		dialog.open();
	}
	
	/**
	 * Opens the Action creation wizard.
	 * 
	 * @param container parent container
	 * @param className class name (includes package nane)
	 */
	public static void openActionWizard(Object container,String className){
		ActionWizard wizard = new ActionWizard();
		wizard.init(PlatformUI.getWorkbench(),new StructuredSelection(container));
		wizard.setClassName(className);
//		Shell shell = Display.getCurrent().getActiveShell();
		WizardDialog dialog = new WizardDialog(null,wizard);
		dialog.open();
	}
	
	/**
	 * Opens tha ActionForm creation wizard.
	 * 
	 * @param container the container
	 * @param className the classname (includes the packagename)
	 */
	public static void openActionFormWizard(Object container,String className){
		ActionFormWizard wizard = new ActionFormWizard();
		wizard.init(PlatformUI.getWorkbench(),new StructuredSelection(container));
		wizard.setClassName(className);
//		Shell shell = Display.getCurrent().getActiveShell();
		WizardDialog dialog = new WizardDialog(null, wizard);
		dialog.open();
	}
	
	/**
	 * Opens the error dialog and output error-log.
	 * 
	 * @param ex Exception
	 */
	public static void openErrorDialog(Throwable ex){
		IStatus status = null;
		if(ex instanceof CoreException){
			status = ((CoreException)ex).getStatus();
		} else {
			status = new Status(IStatus.ERROR,StrutsPlugin.PLUGIN_ID,0,ex.toString(),ex);
		}
		
		ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
		Shell shell = Display.getCurrent().getActiveShell();
		ErrorDialog.openError(shell,
				resource.getString("errorDialog.caption"),
				resource.getString("errorDialog.message"),status);
		logException(ex);
	}
	
	/**
	 * This is utility method to throw CoreException.
	 * 
	 * @param message message
	 */
	public static void throwCoreException(String message) throws CoreException {
		IStatus status = new Status(IStatus.ERROR,
				StrutsPlugin.PLUGIN_ID,
				IStatus.OK,
				message, null);
		throw new CoreException(status);
	}
	
	/**
	 * Logging debug information.
	 * 
	 * @param message message
	 */
	public static void logDebug(String message){
		ILog log = StrutsPlugin.getDefault().getLog();
		IStatus status = new Status(IStatus.INFO,StrutsPlugin.PLUGIN_ID,0,message,null);
		log.log(status);
	}
	
	/**
	 * Logging error information.
	 * 
	 * @param message message
	 */
	public static void logError(String message){
		ILog log = StrutsPlugin.getDefault().getLog();
		IStatus status = new Status(IStatus.ERROR,StrutsPlugin.PLUGIN_ID,0,message,null);
		log.log(status);
	}
	
	/**
	 * Logging exception information.
	 * 
	 * @param ex Exception
	 */
	public static void logException(Throwable ex){
		ILog log = StrutsPlugin.getDefault().getLog();
		IStatus status = null;
		if(ex instanceof CoreException){
			status = ((CoreException)ex).getStatus();
		} else {
			status = new Status(IStatus.ERROR,StrutsPlugin.PLUGIN_ID,0,ex.toString(),ex);
		}
		log.log(status);
		
		// TODO Debug log
		ex.printStackTrace();
	}
	
	/**
	 * Opens the warning dialog.
	 * 
	 * @param message message
	 */
	public static void openAlertDialog(String message){
		ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
		MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(),
				SWT.NULL|SWT.ICON_ERROR);
		box.setMessage(message);
		box.setText(resource.getString("errorDialog.caption"));
		box.open();
	}
	
	/**
	 * Generats message from a template and parameters.
	 * 
	 * @param message message template
	 * @param params parameters
	 * @return generated message
	 */
	public static String createMessage(String message,String[] params){
		for(int i=0;i<params.length;i++){
			message = message.replaceAll("\\{"+i+"\\}",params[i]);
		}
		return message;
	}
	
	/**
	 * Creates a Document object from XML source.
	 * 
	 * @param xml XML source
	 * @return Document object
	 */
	public static Document createXMLDocument(String xml) throws Exception {
		DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		builder.setEntityResolver(new StrutsConfigResolver());
		ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
		Document doc = builder.parse(in);
		in.close();
		return doc;
	}
	
	/**
	 * Creates a Document object from InputStream.
	 * 
	 * @param in InputStream
	 * @return Document object
	 */
	public static Document createXMLDocument(InputStream in) throws Exception {
		DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		builder.setEntityResolver(new StrutsConfigResolver());
		Document doc = builder.parse(in);
		in.close();
		return doc;
	}
	
	
	/**
	 * Creates XML source from a Document object.
	 * 
	 * @param doc Document object
	 * @return XML source
	 */
	public static String createXMLSource(Document doc) throws Exception {
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		
		DocumentType doctype = doc.getDoctype();
		
		TransformerFactory tf=TransformerFactory.newInstance();
		Transformer transformer=tf.newTransformer();
		transformer.setOutputProperty("encoding","UTF-8");
		transformer.setOutputProperty("standalone","false");
		transformer.setOutputProperty("indent","yes");
		transformer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM, doctype.getSystemId());
		transformer.setOutputProperty(OutputKeys.DOCTYPE_PUBLIC, doctype.getPublicId());
		transformer.transform(new DOMSource(doc),new StreamResult(out));
		
		out.flush();
		String xml = new String(out.toByteArray());
		out.close();
		
		return xml;
	}
	
	/**
	 * œnꂽpXNG擾܂B
	 * pXɃNG񂪊܂܂ĂȂꍇ͌̕ԋp܂B
	 * ܂pXnull̏ꍇnullԋp܂B
	 * 
	 * @param path Path
	 * @return pXNG
	 */
	public static String getNoQueryPath(String path){
		if(path==null){
			return null;
		}
		if(path.indexOf("?")!=-1){
			path = path.substring(0,path.indexOf("?"));
		}
		return path;
	}
	
	/**
	 * Returns Commons-Validator rule names.
	 * 
	 * @param project the project
	 * @param moduleName the module name
	 * @return the array that contains rule names
	 */
	public static String[] getValidatorRules(StrutsProject project, String moduleName){
		IFile[] files = project.getValidatorXML(moduleName);
		List<String> ruleNames = new ArrayList<String>();
		for(int i=0;i<files.length;i++){
			try {
				FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
				FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes(doc.getDocumentElement(), "form-validation/global/validator");
				for(int j=0;j<nodes.length;j++){
					String name = ((FuzzyXMLElement) nodes[j]).getAttributeValue("name");
					if(name!=null){
						ruleNames.add(name);
					}
				}
			} catch(Exception ex){
				Util.logException(ex);
			}
		}
		return ruleNames.toArray(new String[ruleNames.size()]);
	}
	
	/**
	 * Opens the action source code or the new action creation wizard.
	 */
	public static void openAction(IProject project, ActionModel model){
		try {
			String type = model.getType();
			if(type==null || type.equals("")){
				Util.openAlertDialog(StrutsPlugin.getResourceString("error.noClassName"));
				return;
			}
			String path = type.replaceAll("\\.","/") + ".java";
			IFile file = project.getFile(path);
			IJavaProject javaProject = JavaCore.create(project);
			IClasspathEntry[] entry = javaProject.getRawClasspath();
			for(int i=0;i<entry.length;i++){
				if(entry[i].getEntryKind()==IClasspathEntry.CPE_SOURCE){
					file = project.getFile(entry[i].getPath().removeFirstSegments(1).append(path));
					break;
				}
			}
			if(file.exists()){
				IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
				IDE.openEditor(window.getActivePage(),file,true);
			} else {
				Util.openActionWizard(project, type);
			}
		} catch(Exception ex){
            Util.openErrorDialog(ex);
		}
	}
	
	/**
	 * Opens the JSP source code or the new JSP creation wizard.
	 */
	public static void openPage(IProject project, PageModel model){
        try {
            HTMLProjectParams params = new HTMLProjectParams(project);
            String webappRoot = params.getRoot();
            ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();

            String path = model.getPath();
            if (path == null || path.equals("")) {
                Util.openAlertDialog(resource.getString("error.noJspPath"));
                return;
            }

            String filename = model.getPath();
            String module = model.getModuleName();
            if (filename != null && module != null
                    && !module.equals("")) {
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                path = "/" + module + path;
            }

            IFile file = project.getFile(webappRoot + Util.getNoQueryPath(path));

            if (file.exists()) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IDE.openEditor(window.getActivePage(), file, true);
            } else {
                IPath containerPath = project.getFullPath();
                containerPath = containerPath.append(webappRoot);
                IContainer container = null;
                if (containerPath.segmentCount() > 1) {
                    container = project.getWorkspace().getRoot().getFolder(containerPath);
                } else {
                    container = project;
                }
                Util.openJSPWizard(container, Util.getNoQueryPath(filename));
            }
        } catch (Exception e) {
            Util.openErrorDialog(e);
        }
	}
	
	/** 
	 * Returns list of property names from IType of ActionForm.
	 * This method should share with FacesIDE.
	 * 
	 * @param type IType of ActionForm
	 * @return list of property names
	 */
	public static PropertyInfo[] getProperties(IType type) throws JavaModelException {
		IMethod[] methods = getMethods(type);
		List<PropertyInfo> list = new ArrayList<PropertyInfo>();
		Set<String> set = new HashSet<String>();
		for(int i=0;i<methods.length;i++){
			String name = methods[i].getElementName();
			String propType = null;
			
			// ignore getClass()
			if(name.equals("getClass")){
				continue;
			}
			// get property name and property type
			if(name.startsWith("get")){
				String returnType = methods[i].getReturnType();
				// ignore void
				if(returnType.equals("V") || methods[i].getParameterTypes().length!=0){
					continue;
				}
				propType = Signature.toString(returnType);
				
			} else if(name.startsWith("set")){
				String[] argTypes = methods[i].getParameterTypes();
				if(argTypes.length==1){
					propType = Signature.toString(argTypes[0]);
				}
				
			} else if(name.startsWith("is")){
				String returnType = methods[i].getReturnType();
				propType = Signature.toString(returnType);
				
			}
			
			if((((name.startsWith("get") || name.startsWith("set")) && name.length() > 3) ||
				(name.startsWith("is") && name.length() > 2)) && propType!=null ){
				
				String propName = getPropertyName(name);
				
				if(name.startsWith("get") || name.startsWith("is") || set.contains(propName + "(" + propType + ")")){
					list.add(new PropertyInfo(type, propName, propType));
				} else {
					set.add(propName + "(" + propType + ")");
				}
			}
		}
		return list.toArray(new PropertyInfo[list.size()]);
	}
	
	/** 
	 * Returns property name from method name.
	 * 
	 * <ul>
	 *   <li>getName -> name</li>
	 *   <li>setName -> name</li>
	 *   <li>isEnable -> enable</li>
	 * </ul>
	 * 
	 * This method should share with FacesIDE.
	 * 
	 * @param methodName namet of an accessor method
	 * @return name of propety
	 */
	private static String getPropertyName(String methodName){
		String name = null;
		if(methodName.startsWith("is")){
			name = methodName.substring(2);
		} else {
			name = methodName.substring(3);
		}
		boolean flag = false;
		for(int i=0;i<name.length();i++){
			char c = name.charAt(i);
			if(c>='a' && c<='z'){
				flag = true;
				break;
			}
		}
		if(flag){
			name = name.substring(0,1).toLowerCase() + name.substring(1);
		}
		return name;
	}
	
	/**
	 * Returns all public methods.
	 * 
	 * @param type
	 * @return all public methods
	 * @throws JavaModelException
	 */
	private static IMethod[] getMethods(IType type) throws JavaModelException {
		List<IMethod> list = new ArrayList<IMethod>();
		IMethod[] methods = type.getMethods();
		for(int i=0;i<methods.length;i++){
			if(!methods[i].isConstructor() && !methods[i].isMainMethod() && Flags.isPublic(methods[i].getFlags())){
				list.add(methods[i]);
			}
		}
		// search super class
		ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
		IType[] superClass = hierarchy.getAllSuperclasses(type);
		for(int i=0;i<superClass.length;i++){
			IMethod[] superMethods = superClass[i].getMethods();
			for(int j=0;j<superMethods.length;j++){
				if(!superMethods[j].isConstructor() && !superMethods[j].isMainMethod() && Flags.isPublic(superMethods[j].getFlags())){
					list.add(superMethods[j]);
				}
			}
		}
		return list.toArray(new IMethod[list.size()]);
	}
	
	public static String getInitialActionPath(RootModel root){
		int count = 1;
		List<AbstractModel> children = root.getChildren();
		while(true){
			boolean cont = false;
			for(int i=0;i<children.size();i++){
				AbstractModel obj = children.get(i);
				if(obj instanceof ActionModel){
					ActionModel action = (ActionModel)obj;
					if(action.getPath().equals("/action" + count)){
						count++;
						cont = true;
						break;
					}
				}
			}
			if(!cont){
				break;
			}
		}
		return "/action" + count;
	}
	
	public static String getInitialForwardName(RootModel root){
		int count = 1;
		List<AbstractModel> children = root.getChildren();
		while(true){
			boolean cont = false;
			for(int i=0;i<children.size();i++){
				AbstractModel obj = children.get(i);
				if(obj instanceof ActionModel){
					ActionModel action = (ActionModel)obj;
					List conns = action.getModelSourceConnections();
					for(int j=0;j<conns.size();j++){
						Object conn = conns.get(j);
						if(conn instanceof ForwardModel){
							ForwardModel forward = (ForwardModel)conn;
							if(forward.getName().equals("forward" + count)){
								count++;
								cont = true;
								break;
							}
						}
					}
				}
				if(cont){
					break;
				}
			}
			if(!cont){
				break;
			}
		}
		return "forward" + count;		
	}
	
	public static String getInitialPagePath(RootModel root){
		int count = 1;
		List children = root.getChildren();
		while(true){
			boolean cont = false;
			for(int i=0;i<children.size();i++){
				Object obj = children.get(i);
				if(obj instanceof PageModel){
					PageModel page = (PageModel)obj;
					if(page.getPath().equals("/page" + count + ".jsp")){
						count++;
						cont = true;
						break;
					}
				}
			}
			if(!cont){
				break;
			}
		}
		return "/page" + count + ".jsp";
	}
}
