package tk.eclipse.plugin.struts.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetEntry;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.struts.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.struts.editors.models.AbstractModel;
import tk.eclipse.plugin.struts.editors.models.ActionMappingsModel;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.ControllerModel;
import tk.eclipse.plugin.struts.editors.models.DataSourceModel;
import tk.eclipse.plugin.struts.editors.models.DataSourcesModel;
import tk.eclipse.plugin.struts.editors.models.DirectForwardModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.FormBeanModel;
import tk.eclipse.plugin.struts.editors.models.FormBeansModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionsModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardsModel;
import tk.eclipse.plugin.struts.editors.models.IncludeModel;
import tk.eclipse.plugin.struts.editors.models.InputModel;
import tk.eclipse.plugin.struts.editors.models.MessageResourcesModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.PluginModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

/**
 * The outline editor based on Eclipse Forms for the <tt>struts-config.xml</tt>.
 * 
 * @author Naoki Takezoe
 * @since 2.0.5
 */
public class FormStrutsConfigEditor extends EditorPart implements PropertyChangeListener {

	private boolean updating = false;
	
	private FormToolkit toolkit;
	private Form form;
	private TreeViewer outlineViewer;
	private Viewer propertyViewer;
	private Composite left;
	private Composite right;
	
	private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
	private MultiPageStrutsConfigEditor editor;
	private RootModel root;
	private AddDataSourceAction addDataSourceAction = new AddDataSourceAction();
	private AddGlobalForwardAction addGlobalForwardAction = new AddGlobalForwardAction();
	private AddGlobalExceptionAction addGlobalExceptionAction = new AddGlobalExceptionAction();
	private AddFormBeanAction addFormBeanAction = new AddFormBeanAction();
	private AddPluginAction addPluginAction = new AddPluginAction();
	private AddMessageResourcesAction addMessageResourcesAction = new AddMessageResourcesAction();
	private AddActionAction addActionAction = new AddActionAction();
	private AddForwardAction addForwardAction = new AddForwardAction();
	private AddExceptionAction addExceptionAction = new AddExceptionAction();
	private DeleteItemAction deleteItemAction = new DeleteItemAction();
	private OpenAction openAction = new OpenAction();
	
	private int actionCount = 0;
	private int pageCount = 0;
	
	public FormStrutsConfigEditor(MultiPageStrutsConfigEditor editor){
		this.editor = editor;
	}
	
	public void doSave(IProgressMonitor monitor) {
	}

	public void doSaveAs() {
	}

	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		setSite(site);
		setInput(input);
	}

	public boolean isDirty() {
		return false;
	}

	public boolean isSaveAsAllowed() {
		return false;
	}

	public void createPartControl(Composite parent) {
		toolkit = new FormToolkit(parent.getDisplay());
		form = toolkit.createForm(parent);
		
//		TableWrapLayout layout = new TableWrapLayout();
//		layout.numColumns = 2;
		GridLayout layout = new GridLayout(2,false);
		form.setText(resource.getString("editor.tab.form"));
		form.getBody().setLayout(layout);
		
		// left side
		createLeftArea();
		// right side
		createRightArea();
		
		toolkit.decorateFormHeading(form);
	}
	
	private void createLeftArea(){
		left = toolkit.createComposite(form.getBody());
		left.setLayoutData(new GridData(GridData.FILL_VERTICAL|GridData.VERTICAL_ALIGN_BEGINNING));
		GridLayout layout = new GridLayout(1, false);
		layout.marginTop    = 0;
		layout.marginBottom = 0;
		layout.marginLeft   = 0;
		layout.marginRight  = 0;
		left.setLayout(layout);
		
		Section section1 = toolkit.createSection(left,Section.DESCRIPTION|Section.TITLE_BAR);
		section1.setText(resource.getString("editor.form.elements"));
		section1.setLayoutData(createGridData(1,GridData.FILL_BOTH));
		
		Composite composite = toolkit.createComposite(section1);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		section1.setClient(composite);
		
		outlineViewer = new TreeViewer(composite);
		outlineViewer.setContentProvider(new StrutsConfigContentProvider());
		outlineViewer.setLabelProvider(new StrutsConfigLabelProvider());
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.widthHint  = 250;
		outlineViewer.getTree().setLayoutData(gd);
		outlineViewer.addSelectionChangedListener(new ISelectionChangedListener(){
			public void selectionChanged(SelectionChangedEvent evt){
				IStructuredSelection sel = (IStructuredSelection)evt.getSelection();
				addDataSourceAction.update(sel);
				addGlobalForwardAction.update(sel);
				addGlobalExceptionAction.update(sel);
				addFormBeanAction.update(sel);
				//addFormPropertyAction.update(sel);
				addActionAction.update(sel);
				addForwardAction.update(sel);
				addExceptionAction.update(sel);
				addPluginAction.update(sel);
				addMessageResourcesAction.update(sel);
				deleteItemAction.clearTarget();
				deleteItemAction.update(sel);
				openAction.update(sel);
				
				propertyViewer.setInput(sel.toArray());
			}
		});
		// select the first element
		//viewer.setSelection(new StructuredSelection(((RootModel)viewer.getInput()).getDataSourcesModel()));
		//viewer.expandAll();
		
		// double-click
		outlineViewer.getControl().addMouseListener(new MouseAdapter(){
			public void mouseDoubleClick(MouseEvent e) {
				ISelection sel = outlineViewer.getSelection();
				if(sel==null || !(sel instanceof IStructuredSelection)){
					return;
				}
				openAction.run();
			}
		});
		
		// create context menu
		MenuManager menu = new MenuManager();
		outlineViewer.getTree().setMenu(menu.createContextMenu(outlineViewer.getTree()));
		
		menu.add(openAction);
		menu.add(new Separator());
		MenuManager add = new MenuManager(resource.getString("outline.menu.add"));
		menu.add(add);
		add.add(addDataSourceAction);
		add.add(addGlobalForwardAction);
		add.add(addGlobalExceptionAction);
		add.add(addFormBeanAction);
		add.add(addActionAction);
		add.add(addForwardAction);
		add.add(addExceptionAction);
		add.add(addPluginAction);
		add.add(addMessageResourcesAction);
		menu.add(deleteItemAction);
	}
	
	private void createRightArea(){
		right = toolkit.createComposite(form.getBody());
		GridLayout layout = new GridLayout(1, false);
		right.setLayout(layout);
		right.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Section section2 = toolkit.createSection(right,Section.DESCRIPTION|Section.TITLE_BAR);
		section2.setLayoutData(createGridData(3,GridData.FILL_BOTH));
		section2.setText(resource.getString("editor.form.properties"));
		
		Composite composite = toolkit.createComposite(section2, SWT.BORDER);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		section2.setClient(composite);
		
		propertyViewer = createPropertyViewer(composite);
		propertyViewer.getControl().setLayoutData(new GridData(GridData.FILL_BOTH));
	}
	
	/**
	 * Creates <code>PropertySheetViewer</code> using reflection.
	 * 
	 * @see org.eclipse.ui.views.properties.PropertySheetViewer
	 */
	private static Viewer createPropertyViewer(Composite parent) {
		try {
			Class<?> clazz = Class.forName("org.eclipse.ui.views.properties.PropertySheetViewer");
			Constructor<?> constructor = clazz.getConstructor(new Class[]{Composite.class});
			constructor.setAccessible(true);
			
			Viewer viewer = (Viewer)constructor.newInstance(new Object[]{parent});
			Method method = clazz.getMethod("setRootEntry", new Class[]{IPropertySheetEntry.class});
			method.setAccessible(true);
			method.invoke(viewer, new Object[]{new PropertySheetEntry()});
			
			return viewer;
		} catch(Exception ex){
			Util.logException(ex);
		}
		return null;
	}	
	
	/** This is a utility method to create GridData. */
	private GridData createGridData(int span,int option){
		GridData gd = new GridData(option);
		gd.horizontalSpan   = span;
		gd.horizontalIndent = 5;
		return gd;
	}
	
	/**
	 * @see PropertyChangeListener#propertyChange(PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		if(updating){
			return;
		}
		if(evt.getPropertyName()==AbstractEntityModel.P_CONSTRAINT){
			return;
		}
		updating = true;
//		update();
		editor.syncEditors(MultiPageStrutsConfigEditor.FLOW_PAGE);
		updating = false;
	}
	
	/**
	 * Updates outline contents.
	 */
	public void update(){
		if(root!=null){
			removeOutlinePropertyListener(root);
		}
		root = editor.getRoot();
		if(outlineViewer!=null){
			outlineViewer.getTree().setRedraw(false);
			IStructuredSelection sel = (IStructuredSelection)outlineViewer.getSelection();
			Object obj = sel.getFirstElement();
			outlineViewer.setSelection(null);
			outlineViewer.setInput(root);
			outlineViewer.refresh();
			outlineViewer.expandAll();
			if(obj!=null){
				outlineViewer.setSelection(new StructuredSelection(obj));
			}
			outlineViewer.getTree().setRedraw(true);
			setOutlinePropertyListener(root);
		}
	}
	
	private void setOutlinePropertyListener(RootModel root){
		List<AbstractModel> children = root.getChildren();
		for(int i = 0; i < children.size(); i++){
			AbstractModel obj = children.get(i);
			obj.addPropertyChangeListener(this);
		}
		root.getDataSourcesModel().addPropertyChangeListener(this);
		root.getGlobalForwardsModel().addPropertyChangeListener(this);
		root.getGlobalExceptionsModel().addPropertyChangeListener(this);
		root.getFormBeansModel().addPropertyChangeListener(this);
		root.getActionMappingsModel().addPropertyChangeListener(this);
	}
	
	private void removeOutlinePropertyListener(RootModel root){
		List<AbstractModel> children = root.getChildren();
		for(int i=0;i<children.size();i++){
			AbstractModel obj = children.get(i);
			obj.removePropertyChangeListener(this);
		}
		root.getGlobalForwardsModel().removePropertyChangeListener(this);
		root.getGlobalExceptionsModel().removePropertyChangeListener(this);
		root.getFormBeansModel().removePropertyChangeListener(this);
		root.getActionMappingsModel().removePropertyChangeListener(this);
	}
	
	public void setFocus() {
		outlineViewer.getTree().setFocus();
	}

	/** An implementation of ContentProvider for StrutsConfigOutlinePage. */
	private class StrutsConfigContentProvider implements ITreeContentProvider {
		public Object[] getChildren(Object parent) {
			// Build outlien from the graphical models
			List<AbstractModel> list = new ArrayList<AbstractModel>();
			
			if(parent instanceof RootModel){
				RootModel rootModel = (RootModel)parent;
				list.add(rootModel.getDataSourcesModel());
				list.add(rootModel.getGlobalForwardsModel());
				list.add(rootModel.getGlobalExceptionsModel());
				list.add(rootModel.getFormBeansModel());
				list.add(rootModel.getActionMappingsModel());
				List<AbstractModel> children = root.getChildren();
				for(int i=0;i<children.size();i++){
					AbstractModel obj = children.get(i);
					if(obj instanceof ControllerModel){
						list.add(obj);
					} else if(obj instanceof MessageResourcesModel){
						list.add(obj);
					} else if(obj instanceof PluginModel){
						list.add(obj);
					}
				}
			} else if(parent instanceof DataSourcesModel){
				list = Util.filtering(root.getChildren(),DataSourceModel.class);
			} else if(parent instanceof GlobalForwardsModel){
				list = Util.filtering(root.getChildren(),GlobalForwardModel.class);
			} else if(parent instanceof GlobalExceptionsModel){
				list = Util.filtering(root.getChildren(),GlobalExceptionModel.class);
			} else if(parent instanceof FormBeansModel){
				list = Util.filtering(root.getChildren(),FormBeanModel.class);
			} else if(parent instanceof ActionMappingsModel){
				list = Util.filtering(root.getChildren(),ActionModel.class);
			} else if(parent instanceof ActionModel){
				List<AbstractConnectionModel> conns = ((ActionModel) parent).getModelSourceConnections();
				list = new ArrayList<AbstractModel>(conns);
                // (MVL) remove inputs, direct forwards and includes
                Iterator<AbstractModel> it = list.iterator();
                while (it.hasNext()) {
                	AbstractModel model = it.next();
                    if (model instanceof DirectForwardModel) {
                        it.remove();
                    } else if (model instanceof IncludeModel) {
                        it.remove();
                    } else if (model instanceof InputModel) {
                        it.remove();
                    }
                }
			} 
			return list.toArray();
		}
		public Object getParent(Object element) {
			return null;
		}
		public boolean hasChildren(Object element) {
			if(getChildren(element).length==0){
				return false;
			} else {
				return true;
			}
		}
		public Object[] getElements(Object inputElement) {
			return getChildren(inputElement);
		}
		public void dispose() {
		}
		public void inputChanged(Viewer viewer, Object oldInput,Object newInput) {
		}
	}
	
	/** An implementation of LabelProvider for StrutsConfigOutlinePage. */
	private class StrutsConfigLabelProvider extends LabelProvider {
		public Image getImage(Object element) {
			if(element instanceof ActionModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_ACTION);
			} else if(element instanceof ForwardModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_FORWARD);
			} else if(element instanceof FormBeanModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_BEAN);
			} else if(element instanceof FormBeansModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_BEANS);
			} else if(element instanceof ActionMappingsModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_ACTIONS);
			} else if(element instanceof GlobalForwardsModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_GLOBALS);
			} else if(element instanceof ControllerModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_CONTROLLER);
			} else if(element instanceof MessageResourcesModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_WEBPAGE);
			} else if(element instanceof PluginModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_PLUGIN);
			} else if(element instanceof GlobalForwardModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_FORWARD);
			} else if(element instanceof GlobalExceptionsModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_GLOBAL_EX);
			} else if(element instanceof GlobalExceptionModel || element instanceof ExceptionModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_EXCEPTION);
			} else if(element instanceof DataSourcesModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_DATASOURCES);
			} else if(element instanceof DataSourceModel){
				return StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_DATASOURCE);
			}
			return super.getImage(element);
		}
		public String getText(Object element) {
			if(element instanceof ActionModel){
				String path = ((ActionModel)element).getPath();
				if(path.equals("")){
					return "<action>";
				}
				return path;
			} else if(element instanceof ForwardModel){
				String name = ((ForwardModel)element).getName();
				if(name.equals("")){
					return "<forward>";
				}
				return name;
			} else if(element instanceof FormBeanModel){
				String name = ((FormBeanModel)element).getName();
				if(name.equals("")){
					return "<form-bean>";
				}
				return name;
			} else if(element instanceof ControllerModel){
				return "controller";
			} else if(element instanceof MessageResourcesModel){
				return "message-resources";
			} else if(element instanceof PluginModel){
				return "plug-in";
			} else if(element instanceof GlobalForwardModel){
				String name = ((GlobalForwardModel)element).getName();
				if(name.equals("")){
					name = "<forward>";
				}
				return name;
			} else if(element instanceof GlobalExceptionModel){
				String type = ((GlobalExceptionModel)element).getType();
				if(type.equals("")){
					type = "<exception>";
				}
				return type;
			} else if(element instanceof ExceptionModel){
				String type = ((ExceptionModel)element).getType();
				if(type.equals("")){
					type = "<exception>";
				}
				return type;
			} else if(element instanceof DataSourceModel){
				String type = ((DataSourceModel)element).getType();
				if(type.equals("")){
					type = "<data-source>";
				}
				return type;
			} else if(element instanceof GlobalForwardsModel){
				return "global-forwards";
			} else if(element instanceof GlobalExceptionsModel){
				return "global-exceptions";
			} else if(element instanceof ActionMappingsModel){
				return "action-mappings";
			} else if(element instanceof DataSourcesModel){
				return "data-sources";
			} else if(element instanceof FormBeansModel){
				return "form-beans";
			}
			
			return super.getText(element);
		}
	}
	
	/** Add data-source action */
	private class AddDataSourceAction extends Action {
		public AddDataSourceAction(){
			super("data-source",StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_DATASOURCE));
		}
		public void update(IStructuredSelection sel){
			Object obj = sel.getFirstElement();
			setEnabled(obj!=null && obj instanceof DataSourcesModel);
		}
		public void run(){
			DataSourceModel model = new DataSourceModel();
			model.addPropertyChangeListener(FormStrutsConfigEditor.this);
			root.addChild(model);
			outlineViewer.refresh();
			outlineViewer.setSelection(new StructuredSelection(model));
		}
	}
	
	/** Add global-forward action */
	private class AddGlobalForwardAction extends Action {
		public AddGlobalForwardAction(){
			super("global-forward",StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_FORWARD));
		}
		public void update(IStructuredSelection sel){
			Object obj = sel.getFirstElement();
			setEnabled(obj!=null && obj instanceof GlobalForwardsModel);
		}
		public void run() {
			GlobalForwardModel model = new GlobalForwardModel();
			model.addPropertyChangeListener(FormStrutsConfigEditor.this);
			root.addChild(model);
			outlineViewer.refresh();
			outlineViewer.setSelection(new StructuredSelection(model));
		}
	}
	
	/** Add global-exception action */
	private class AddGlobalExceptionAction extends Action {
		public AddGlobalExceptionAction(){
			super("global-exception",StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_EXCEPTION));
		}
		public void update(IStructuredSelection sel){
			Object obj = sel.getFirstElement();
			setEnabled(obj!=null && obj instanceof GlobalExceptionsModel);
		}
		public void run() {
			GlobalExceptionModel model = new GlobalExceptionModel();
			model.addPropertyChangeListener(FormStrutsConfigEditor.this);
			root.addChild(model);
			outlineViewer.refresh();
			outlineViewer.setSelection(new StructuredSelection(model));
		}
	}
	
	/** Add form-bean action */
	private class AddFormBeanAction extends Action {
		public AddFormBeanAction(){
			super("form-bean",StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_BEAN));
		}
		public void update(IStructuredSelection sel){
			Object obj = sel.getFirstElement();
			setEnabled(obj!=null && obj instanceof FormBeansModel);
		}
		public void run() {
			FormBeanModel model = new FormBeanModel();
			model.addPropertyChangeListener(FormStrutsConfigEditor.this);
			root.addChild(model);
			outlineViewer.refresh();
			outlineViewer.setSelection(new StructuredSelection(model));
		}
	}
	
	/** Add plug-in action */
	private class AddPluginAction extends Action {
		public AddPluginAction(){
			super("plug-in",StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_PLUGIN));
		}
		public void update(IStructuredSelection sel){
			setEnabled(true);
		}
		public void run() {
			PluginModel model = new PluginModel();
			model.addPropertyChangeListener(FormStrutsConfigEditor.this);
			root.addChild(model);
			outlineViewer.refresh();
			outlineViewer.setSelection(new StructuredSelection(model));
		}
	}
	
	/** Add message-resources action */
	private class AddMessageResourcesAction extends Action {
		public AddMessageResourcesAction(){
			super("message-resources",StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_WEBPAGE));
		}
		public void update(IStructuredSelection sel){
			setEnabled(true);
		}
		public void run() {
			MessageResourcesModel model = new MessageResourcesModel();
			model.addPropertyChangeListener(FormStrutsConfigEditor.this);
			root.addChild(model);
			outlineViewer.refresh();
			outlineViewer.setSelection(new StructuredSelection(model));
		}
	}
	
	/** Add action action */
	private class AddActionAction extends Action {
		public AddActionAction(){
			super("action",StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ACTION));
		}
		public void update(IStructuredSelection sel){
			Object obj = sel.getFirstElement();
			setEnabled(obj!=null && obj instanceof ActionMappingsModel);
		}
		public void run(){
			StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
			try {
				ActionModel action = new ActionModel();
				action.setPath(Util.getInitialActionPath(root));
				action.setConstraint(new Rectangle(10, 10 + (actionCount++ * 60), -1, -1));
				action.addPropertyChangeListener(FormStrutsConfigEditor.this);
				root.addChild(action);
				
				// force synchronize
				propertyChange(new PropertyChangeEvent(root, RootModel.P_CHILDREN, null, null));
				
				outlineViewer.refresh();
				outlineViewer.setSelection(new StructuredSelection(action));
			} finally {
				StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
			}
		}
	}
	
	/** Add forward action */
	private class AddForwardAction extends Action {
		private ActionModel targetModel;
		public AddForwardAction(){
			super("foward",StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_FORWARD));
		}
		public void update(IStructuredSelection sel){
			Object obj = sel.getFirstElement();
			setEnabled(obj!=null && obj instanceof ActionModel);
			targetModel = isEnabled() ? (ActionModel) obj : null;
		}
		public void run(){
			StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
			try {
				ForwardModel forward = new ForwardModel();
				
				PageModel page = new PageModel();
				page.setPath(Util.getInitialPagePath(root));
				page.setConstraint(new Rectangle(200, 10 + (pageCount++ * 60), -1, -1));
				page.addPropertyChangeListener(FormStrutsConfigEditor.this);
				root.addChild(page);
				
				forward.setSource(targetModel);
				forward.setName(Util.getInitialForwardName(root));
				forward.setTarget(page);
				forward.addPropertyChangeListener(FormStrutsConfigEditor.this);
				targetModel.addSourceConnection(forward);
				page.addTargetConnection(forward);
				
				// force synchronize
				propertyChange(new PropertyChangeEvent(root, RootModel.P_CHILDREN, null, null));
				
				outlineViewer.refresh();
				outlineViewer.setSelection(new StructuredSelection(forward));
			} finally {
				StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
			}
		}
	}
	
	/** Add exception action */
	private class AddExceptionAction extends Action {
		private ActionModel targetModel;
		public AddExceptionAction(){
			super("exception",StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_EXCEPTION));
		}
		public void update(IStructuredSelection sel){
			Object obj = sel.getFirstElement();
			setEnabled(obj!=null && obj instanceof ActionModel);
			targetModel = isEnabled() ? (ActionModel) obj : null;
		}
		public void run(){
			// TODO unimplemented!
			StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
			try {
				ExceptionModel exception = new ExceptionModel();
				
				PageModel page = new PageModel();
				page.setPath(Util.getInitialPagePath(root));
				page.setConstraint(new Rectangle(200, 10 + (pageCount++ * 60), -1, -1));
				page.addPropertyChangeListener(FormStrutsConfigEditor.this);
				root.addChild(page);
				
				exception.setSource(targetModel);
				exception.setTarget(page);
				exception.addPropertyChangeListener(FormStrutsConfigEditor.this);
				targetModel.addSourceConnection(exception);
				page.addTargetConnection(exception);
				
				// force synchronize
				propertyChange(new PropertyChangeEvent(root, RootModel.P_CHILDREN, null, null));
				
				outlineViewer.refresh();
				outlineViewer.setSelection(new StructuredSelection(exception));
			} finally {
				StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
			}
		}
	}
	
	/** Remove selection action */
	private class DeleteItemAction extends Action {
    	private List<AbstractModel> targetmodel = new ArrayList<AbstractModel>();
		public void clearTarget() {
        	targetmodel.clear();
        }
        public DeleteItemAction() {
            super(resource.getString("outline.menu.remove"));
        }
		public void update(IStructuredSelection sel){
			Object obj = sel.getFirstElement();
			if(obj!=null && (
					obj instanceof FormBeanModel      || obj instanceof ActionModel           ||
					obj instanceof GlobalForwardModel || obj instanceof GlobalExceptionModel  ||
					obj instanceof PluginModel        || obj instanceof MessageResourcesModel ||
					obj instanceof ForwardModel       || obj instanceof ExceptionModel       || 
					obj instanceof DataSourceModel)){
				setEnabled(true);
                Iterator<?> sellist = sel.iterator();
                while (sellist.hasNext()) {
                    targetmodel.add((AbstractModel) sellist.next());
                }
            } else {
                setEnabled(false);
            }
		}
		public void run() {
        	List<EditPart> deleteCommandList = new ArrayList<EditPart>();
        	List<AbstractModel> deleteChildList = new ArrayList<AbstractModel>();
        	
            for (int idx = 0; idx < targetmodel.size(); idx++) {
				Object target = targetmodel.get(idx);
				
				if (target instanceof FormBeanModel
						|| target instanceof GlobalForwardModel
						|| target instanceof GlobalExceptionModel
						|| target instanceof PluginModel
						|| target instanceof MessageResourcesModel
						|| target instanceof DataSourceModel) {
					deleteChildList.add((AbstractModel) target);
					
				} else if (target instanceof ActionModel
						|| target instanceof ForwardModel) {
					List<EditPart> editPartList = editor.getGraphicalEditor().getEditParts();
					if (editPartList != null) {
						for (int i = 0; i < editPartList.size(); i++) {
							EditPart editPartParent = editPartList.get(i);

							if (editPartParent.getModel().equals(target)) {
								deleteCommandList.add(editPartParent);
							}
						}
					}
				}
			}
            if ( deleteCommandList.size() > 0 ){
	            execute(createDeleteCommand(deleteCommandList));
            }
            for (int i = 0; deleteChildList.size() > i; i++) {
            	root.removeChild(deleteChildList.get(i));
            }
            outlineViewer.refresh();
		}

        /**
         * Create a command to remove the selected objects.
         * @param objects The objects to be deleted.
         * @return The command to remove the selected objects.
         */
        private Command createDeleteCommand(List<EditPart> objects) {
            if (objects.isEmpty())
                return null;
            if (!(objects.get(0) instanceof EditPart))
                return null;

            GroupRequest deleteReq = new GroupRequest(RequestConstants.REQ_DELETE);
            deleteReq.setEditParts(objects);

            CompoundCommand compoundCmd = new CompoundCommand(GEFMessages.DeleteAction_ActionDeleteCommandName);
            for (int i = 0; i < objects.size(); i++) {
                EditPart object = (EditPart) objects.get(i);
                Command cmd = object.getCommand(deleteReq);
                if (cmd != null)
                    compoundCmd.add(cmd);
            }

            return compoundCmd;
        }
        /**
         * Executes the given {@link Command} using the command stack. The stack is obtained by calling
         * {@link #getCommandStack()}, which uses <code>IAdapatable</code> to retrieve the stack from the workbench part.
         * @param command the command to execute
         */
        private void execute(Command command) {
            if (command == null || !command.canExecute())
                return;
            getCommandStack().execute(command);
        }

        /**
         * Returns the editor's command stack. This is done by asking the workbench part for its CommandStack via
         * {@link org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)}.
         * @return the command stack
         */
        private CommandStack getCommandStack() {
            return (CommandStack) getWorkbenchPart().getAdapter(
                    CommandStack.class);
        }
        
        /**
         * Returns the workbench part given in the constructor
         * @return the workbench part
         */
        private IWorkbenchPart getWorkbenchPart() {
            return (IWorkbenchPart) editor.getGraphicalEditor();
        }
        
	}
	
	/** Open selection action */
	private class OpenAction extends Action {
		private Object target;
		public OpenAction(){
			super(resource.getString("outline.menu.open"));
		}
		public void update(IStructuredSelection sel){
            Object obj = sel.getFirstElement();
            target = obj;
            if (obj != null) {
                if (obj instanceof FormBeanModel
                		|| obj instanceof ActionModel) {
                	setEnabled(true);
                    return;
                }
            }
            setEnabled(false);
		}
		public void run() {
			if(target instanceof ActionModel){
				String path = ((ActionModel)target).getPath();
				setFocus(editor, "/struts-config/action-mappings/action", "path", path);
			} else if(target instanceof FormBeanModel){
				String name = ((FormBeanModel)target).getName();
       			setFocus(editor, "/struts-config/form-beans/form-bean", "name", name);
			} else if(target instanceof DataSourceModel) {
				String type = ((DataSourceModel)target).getType();
				setFocus(editor, "/struts-config/data-sources/data-source", "type", type);
			} else if(target instanceof GlobalForwardModel) {
				String name = ((GlobalForwardModel)target).getName();
				setFocus(editor, "/struts-config/global-forwards/forward", "name", name);
			} else if(target instanceof GlobalExceptionModel) {
				String type = ((GlobalExceptionModel)target).getType();
				setFocus(editor, "/struts-config/global-exceptions/exception", "type", type);
			} else if(target instanceof MessageResourcesModel) {
				String parameter = ((MessageResourcesModel)target).getParameter();
				setFocus(editor, "/struts-config/message-resources", "parameter", parameter);
			} else if(target instanceof ControllerModel) {
				String processorClass = ((ControllerModel)target).getClassName();
				setFocus(editor, "/struts-config/controller", "processorClass", processorClass);
			} else if(target instanceof PluginModel) {
				String className = ((PluginModel)target).getClassName();
				setFocus(editor, "/struts-config/plug-in", "className", className);
			}
			
		}
		private boolean setFocus(MultiPageStrutsConfigEditor editor, String tagName, String attrName,
	            String targetAttrValue) {
			StrutsConfigXMLEditor xmlEditor = (StrutsConfigXMLEditor) editor.getXMLEditor();
			if (xmlEditor.setFocusAttrValue(tagName, attrName, targetAttrValue)) {
				editor.setActivePage(MultiPageStrutsConfigEditor.XML_PAGE);
				editor.setFocus();
				return true;
			}
			Util.openAlertDialog(Util.createMessage(resource
                    .getString("error.notexists"),
                    new String[] { "/" + tagName + "/" +  attrName + "=" + targetAttrValue}));
			return false;
		}
	}

}
