package tk.eclipse.plugin.struts.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.editparts.StrutsConfigEditPartFactory;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.DirectForwardModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.IncludeModel;
import tk.eclipse.plugin.struts.editors.models.InputModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.struts.editors.tree.ActionTreeEditPart;
import tk.eclipse.plugin.struts.editors.tree.DirectForwardTreeEditPart;
import tk.eclipse.plugin.struts.editors.tree.ExceptionTreeEditPart;
import tk.eclipse.plugin.struts.editors.tree.ForwardTreeEditPart;
import tk.eclipse.plugin.struts.editors.tree.IncludeTreeEditPart;
import tk.eclipse.plugin.struts.editors.tree.InputTreeEditPart;
import tk.eclipse.plugin.struts.editors.tree.PageTreeEditPart;
import tk.eclipse.plugin.struts.editors.tree.RootTreeEditPart;
import tk.eclipse.plugin.struts.editors.tree.StrutsConfigTreeEditPartFactory;

/**
 * Ths visual editor for struts-config.xml.
 */
public class GraphicalStrutsConfigEditor extends GraphicalEditorWithPalette implements IPropertyChangeListener {
	
	private RootModel root;
	private ContentOutlinePage outlinePage;
	private boolean savePreviouslyNeeded = false;
	private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
	private RunOnServerAction runAction;
	
	//private OpenAction openAction = new OpenAction();
	
	public static final String OPEN_SELECTION = "__struts_config_open_selection";
	
	public GraphicalStrutsConfigEditor(MultiPageStrutsConfigEditor editor) {
		super();
		this.outlinePage = new ContentOutlinePage(editor);
		setEditDomain(new DefaultEditDomain(this));
		getActionRegistry().registerAction(new UndoRetargetAction());
		getActionRegistry().registerAction(new RedoRetargetAction());
//		getActionRegistry().registerAction(new DeleteRetargetAction());
		getActionRegistry().registerAction(new OpenAction());
		
		StrutsPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this);
	}
	
	/**
	 * Returns editor actions
	 */
	public IAction getAction(Object key){
		return getActionRegistry().getAction(key);
	}
	
	/**
	 * Creates the tool palette.
	 */
	protected PaletteRoot getPaletteRoot() {
		PaletteRoot root = new PaletteRoot();
		
		// selection tools group
		PaletteGroup tools = new PaletteGroup(resource.getString("editor.palette.group.tool"));
		// selection
		ToolEntry tool = new SelectionToolEntry();
		tools.add(tool);
		root.setDefaultEntry(tool);
		// marquee
		tool = new MarqueeToolEntry();
		tools.add(tool);
		
		// entity model creation tools group
		PaletteDrawer flows = new PaletteDrawer(resource.getString("editor.palette.group.entity"));
		
		CreationToolEntry actionEntry = new CreationToolEntry(
				resource.getString("editor.palette.action"),resource.getString("editor.palette.action.tooltip"),
				new ActionModelFactory(),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ACTION),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ACTION));
		flows.add(actionEntry);
		
		CreationToolEntry pageEntry = new CreationToolEntry(
				resource.getString("editor.palette.page"),resource.getString("editor.palette.page.tooltip"),
				new PageModelFactory(),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_WEBPAGE),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_WEBPAGE));
		flows.add(pageEntry);
		
		// connection model creation tools group
		PaletteDrawer navigation = new PaletteDrawer(resource.getString("editor.palette.group.navigation"));
		
		ConnectionCreationToolEntry forwardEntry = new ConnectionCreationToolEntry(
				resource.getString("editor.palette.forward"),resource.getString("editor.palette.forward.tooltip"),
				new ForwardModelFactory(),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ARROW_FW),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ARROW_FW));
		navigation.add(forwardEntry);
		
		ConnectionCreationToolEntry exceptionEntry = new ConnectionCreationToolEntry(
				resource.getString("editor.palette.exception"),resource.getString("editor.palette.exception.tooltip"),
				new SimpleFactory(ExceptionModel.class),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ARROW_EX),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ARROW_EX));
		navigation.add(exceptionEntry);
		
		ConnectionCreationToolEntry inputEntry = new ConnectionCreationToolEntry(
				resource.getString("editor.palette.input"),resource.getString("editor.palette.input.tooltip"),
				new SimpleFactory(InputModel.class),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ARROW_INP),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ARROW_INP));
		navigation.add(inputEntry);
		
		ConnectionCreationToolEntry directForwardEntry = new ConnectionCreationToolEntry(
				resource.getString("editor.palette.directforward"),resource.getString("editor.palette.directforward.tooltip"),
				new SimpleFactory(DirectForwardModel.class),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ARROW_DFW),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ARROW_DFW));
		navigation.add(directForwardEntry);
		
		ConnectionCreationToolEntry includeEntry = new ConnectionCreationToolEntry(
				resource.getString("editor.palette.include"),resource.getString("editor.palette.include.tooltip"),
				new SimpleFactory(IncludeModel.class),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ARROW_INC),
				StrutsPlugin.getDefault().getDescriptor(StrutsPlugin.ICON_ARROW_INC));
		navigation.add(includeEntry);
		
		// add groups to root
		root.add(tools);
		root.add(flows);
		root.add(navigation);
		
		return root;
	}
	
	public RootModel getRoot(){
		return root;
	}
	
	public void setRoot(RootModel model){
		if(model!=null){
			GraphicalViewer viewer = getGraphicalViewer();
			viewer.setContents(model);
			this.root = model;
//			this.root.addPropertyChangeListener(outlinePage);
		}
	}
	
	private File getBinaryFile(IFile file){
		return new File(file.getParent().getLocation().makeAbsolute().toFile(),
				"." + file.getName() + ".strutside");
	}
	
	/**
	 * Initializes the GraphicalViewer.
	 */
	protected void initializeGraphicalViewer() {
		final GraphicalViewer viewer = getGraphicalViewer();
//		outlinePage.setGraphicalViewer(getGraphicalViewer());
		
		ScalableFreeformRootEditPart rootEditPart = new ScalableFreeformRootEditPart();
		viewer.setRootEditPart(rootEditPart);
		
		// ZoomManager
		ZoomManager manager = rootEditPart.getZoomManager();
		getActionRegistry().registerAction(new ZoomInAction(manager));
		getActionRegistry().registerAction(new ZoomOutAction(manager));
		
		IFile file = ((IFileEditorInput)getEditorInput()).getFile();
		File binary = getBinaryFile(file);
		
		// Restore if serialized file does exist
		if(binary.exists()){
			try {
				ObjectInputStream ois = new ObjectInputStream(new FileInputStream(binary));
				root = (RootModel)ois.readObject();
				ois.close();
			} catch(Exception ex){
				//ex.printStackTrace();
				root = new RootModel();
			}
		} else {
			root = new RootModel();
//			root.addPropertyChangeListener(outlinePage);
		}
		viewer.setContents(root);
		
		final DeleteAction deleteAction = new DeleteAction((IWorkbenchPart) this);
		deleteAction.setSelectionProvider(getGraphicalViewer());
		getActionRegistry().registerAction(deleteAction);
		getGraphicalViewer().addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				deleteAction.update();
			}
		});
		
		PrintAction printAction = new PrintAction(this);
		printAction.setImageDescriptor(
				StrutsPlugin.getDefault().getImageRegistry().getDescriptor(StrutsPlugin.ICON_PRINT));
		printAction.setText(StrutsPlugin.getResourceString("action.print"));
		getActionRegistry().registerAction(printAction);
		
		// Create a context menu
		MenuManager menuMgr = new MenuManager();
		menuMgr.add(new GroupMarker("open"));
		//menuMgr.add(getAction(OPEN_SELECTION));
		menuMgr.add(new GroupMarker("open_end"));
		menuMgr.add(new Separator("edit"));
		menuMgr.add(getAction(ActionFactory.UNDO.getId()));
		menuMgr.add(getAction(ActionFactory.REDO.getId()));
		menuMgr.add(getAction(ActionFactory.DELETE.getId()));
		menuMgr.add(new Separator("layout"));
		menuMgr.add(new AutoLayoutAction(getGraphicalViewer()));
		menuMgr.add(new Separator("zoom"));
		menuMgr.add(getAction(GEFActionConstants.ZOOM_IN));
		menuMgr.add(getAction(GEFActionConstants.ZOOM_OUT));
		menuMgr.add(new Separator("print"));
		menuMgr.add(new SaveAsImageAction(viewer));
		menuMgr.add(printAction);
		menuMgr.add(new Separator("run"));
		runAction = new RunOnServerAction(file.getProject(), viewer);
		menuMgr.add(runAction);
		menuMgr.addMenuListener(new IMenuListener(){
			public void menuAboutToShow(IMenuManager manager) {
				runAction.update();
			}
		});
		viewer.setContextMenu(menuMgr);
		
		menuMgr.addMenuListener(new IMenuListener(){
			public void menuAboutToShow(IMenuManager manager){
				IStructuredSelection sel = (IStructuredSelection)getGraphicalViewer().getSelection();
				Object selObj = sel.getFirstElement();
				Object selTarget = (selObj instanceof EditPart) ? ((EditPart) selObj).getModel() : null;
				
				updateContextMenu(manager,selTarget);
			}
		});
		setPartName(((IFileEditorInput) getEditorInput()).getFile().getName());
		
		applyPreferences();
	}
	
	public void updateContextMenu(IMenuManager manager, Object target) {
		// remove all open actions
		IContributionItem[] items = manager.getItems();
		for (int i=0; i<items.length; i++) {
			if (items[i].getId() != null && items[i].getId().startsWith(OPEN_SELECTION)) {
				manager.remove(items[i]);
				getActionRegistry().removeAction(((ActionContributionItem)items[i]).getAction());
			}
		}
		if (target instanceof ActionModel){
			ActionModel model = (ActionModel) target;
			OpenAction action = new OpenAction();
			getActionRegistry().registerAction(action);
			manager.appendToGroup("open",action);
			action.setEnabled(!model.getType().equals("") && model.getType().indexOf('{') < 0);
			action.update(target);
			
		} else if (target instanceof PageModel){
			PageModel model = (PageModel) target;
			if (model.isTile()) {
				String[] paths = model.getPaths();
				for (int i=0; i<paths.length; i++) {
					OpenAction action = new OpenAction(OPEN_SELECTION+"_"+i,paths[i]);
					getActionRegistry().registerAction(action);
					manager.appendToGroup("open",action);
					action.setEnabled(true);
					action.update(target);
				}
			} else {
				OpenAction action = new OpenAction();
				getActionRegistry().registerAction(action);
				manager.appendToGroup("open",action);
				action.setEnabled(!model.getPath().equals("") && model.getPath().indexOf('{') < 0);
				action.update(target);
			}
		}
		manager.update(true);
	}
	
	/**
	 * The action to open or create JSP and actions.
	 */
	private class OpenAction extends Action {
		
		private Object target;
		private String filename;
		
		public OpenAction() {
			this(OPEN_SELECTION, null);
		}
		
		public OpenAction(String id, String filename){
			super(resource.getString("outline.menu.open") + (filename==null ? "" : " " + filename));
			this.filename = filename;
			setId(id);
		}
		
		public void update(Object selTarget){
			target = selTarget;
		}
		
		public void run(){
			try {
				HTMLProjectParams params = new HTMLProjectParams(getProject());
				String webappRoot = params.getRoot();
				
				if(target instanceof PageModel){
					String path = filename != null ? filename : ((PageModel)target).getPath();
					if(path==null || path.equals("")){
						Util.openAlertDialog(resource.getString("error.noJspPath"));
						return;
					}
					
					String module = ((PageModel)target).getModuleName();
					if(filename==null && module!=null && !module.equals("")){
						if(!path.startsWith("/")){
							path = "/" + path;
						}
						path = "/" + module + path;
					}
					
					IFile file = getProject().getFile(webappRoot + Util.getNoQueryPath(path));
					if(file.exists()){
						IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
						IDE.openEditor(window.getActivePage(),file,true);
					} else {
						Util.openJSPWizard(file.getParent(),file.getName());
					}
				} else if(target instanceof ActionModel){
					Util.openAction(getProject(), (ActionModel)target);
				}
			} catch(Exception ex){
				Util.openErrorDialog(ex);
			}
		}
	}
	
	public void doSave(){
		doSave(getEditorInput());
	}
	
	public void doSave(IEditorInput input){
		setInput(input);
		try {
			IFile file = ((IFileEditorInput)getEditorInput()).getFile();
			File binary = getBinaryFile(file);
			FileOutputStream out = new FileOutputStream(binary);
			writeModel(out);
			out.close();
		} catch(Exception ex){
			Util.openErrorDialog(ex);
		}
		getCommandStack().markSaveLocation();
	}
	
	/** Writes a serialized model to OutputStream. */
	private void writeModel(OutputStream os) throws IOException {
		ObjectOutputStream out = new ObjectOutputStream(os);
		out.writeObject(root);
		out.close();	
	}
	
	public void doSave(IProgressMonitor monitor) {
		// Nothing to do.
	}
	
	public void doSaveAs() {
		// Nothing to do.
	}
	
	public boolean isDirty() {
		return isSaveOnCloseNeeded();
	}
	
	public boolean isSaveOnCloseNeeded() {
		return getCommandStack().isDirty();
	}
	
	public void commandStackChanged(EventObject event) {
		if (isDirty()) {
			if (!savePreviouslyNeeded()) {
				setSavePreviouslyNeeded(true);
				firePropertyChange(IEditorPart.PROP_DIRTY);
			}
		} else {
			setSavePreviouslyNeeded(false);
			firePropertyChange(IEditorPart.PROP_DIRTY);
		}
		super.commandStackChanged(event);
	}
	
	private void setSavePreviouslyNeeded(boolean value) {
		savePreviouslyNeeded = value;
	}
	
	private boolean savePreviouslyNeeded() {
		return savePreviouslyNeeded;
	}
	
	public boolean isSaveAsAllowed() {
		return true;
	}
	
	public void refresh(){
		getGraphicalViewer().getContents().refresh();
	}
	
	public IProject getProject(){
		return ((IFileEditorInput)getEditorInput()).getFile().getProject();
	}
	
	@Override
	protected void configureGraphicalViewer() {
		super.configureGraphicalViewer();
		GraphicalViewer viewer = getGraphicalViewer();
		viewer.setEditPartFactory(new StrutsConfigEditPartFactory(this));
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public Object getAdapter(Class type) {
		if (type == ZoomManager.class){
			return ((ScalableFreeformRootEditPart) getGraphicalViewer().getRootEditPart()).getZoomManager();
		}
		if(type == IContentOutlinePage.class){
			return this.outlinePage;
		}
		return super.getAdapter(type);
	}
	
	/** Factory of PageModel */
	private class PageModelFactory implements CreationFactory {
		public Object getNewObject() {
			StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
			try {
				PageModel model = new PageModel();
				model.setPath(Util.getInitialPagePath(getRoot()));
				return model;
			} catch (Exception exc) {
				exc.printStackTrace();
				return null;
			} finally {
				StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
			}
		}
		public Object getObjectType() {
			return PageModel.class;
		}		
	}
	
	/** Factory of ActionModel */
	private class ActionModelFactory implements CreationFactory {
		public Object getNewObject() {
			StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
			try {
				ActionModel model = new ActionModel();
				model.setPath(Util.getInitialActionPath(getRoot()));
				return model;
			} catch (Exception exc) {
				exc.printStackTrace();
				return null;
			} finally {
				StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
			}
		}
		public Object getObjectType() {
			return ActionModel.class;
		}		
	}
	
	/** Factory of ForwardModel */
	private class ForwardModelFactory implements CreationFactory {
		public Object getNewObject() {
			StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
			try {
				ForwardModel model = new ForwardModel();
				model.setName(Util.getInitialForwardName(getRoot()));
				return model;
			} catch (Exception exc) {
				exc.printStackTrace();
				return null;
			} finally {
				StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
			}
		}
		public Object getObjectType() {
			return ForwardModel.class;
		}		
	}
	protected void flushCommandStack() {
		super.getCommandStack().flush();
	}
    protected List<EditPart> getEditParts() {
        List<EditPart> editPartList = new ArrayList<EditPart>();
        Map<?, ?> editMap = getGraphicalViewer().getVisualPartMap();
        Set<?> key = editMap.keySet();
        Iterator<?> itr = key.iterator();
        while (itr.hasNext()) {
            editPartList.add((EditPart) editMap.get(itr.next()));
        }
        return editPartList;
    }
    
	protected void applyPreferences(){
		IPreferenceStore store = StrutsPlugin.getDefault().getPreferenceStore();

		getGraphicalViewer().setProperty(SnapToGrid.PROPERTY_GRID_ENABLED,
		                new Boolean(store.getBoolean(StrutsPlugin.PREF_SHOW_GRID)));
		getGraphicalViewer().setProperty(SnapToGrid.PROPERTY_GRID_VISIBLE,
		                new Boolean(store.getBoolean(StrutsPlugin.PREF_SHOW_GRID)));

		int gridSize = store.getInt(StrutsPlugin.PREF_GRID_SIZE);
		getGraphicalViewer().setProperty(SnapToGrid.PROPERTY_GRID_SPACING,
		                new Dimension(gridSize, gridSize));

		getGraphicalViewer().setProperty(SnapToGeometry.PROPERTY_SNAP_ENABLED,
		                new Boolean(store.getBoolean(StrutsPlugin.PREF_SNAP_GEOMETRY)));
	}    
    
	public void propertyChange(PropertyChangeEvent event) {
		applyPreferences();
	}
	
	@Override
	public void dispose(){
		StrutsPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this);
		super.dispose();
	}
	
	/** OutlinePage **/
    private class ContentOutlinePage extends
			org.eclipse.gef.ui.parts.ContentOutlinePage {
		private SashForm sash = null;

		private ScrollableThumbnail thumbnail = null;

		private DisposeListener disposeListener = null;

		private OpenAction openAction;

		private MultiPageStrutsConfigEditor editor;

		public ContentOutlinePage(MultiPageStrutsConfigEditor editor) {
			super(new TreeViewer());
			this.editor = editor;
			openAction = new OpenAction();
		}

		@Override
		public void init(IPageSite pageSite) {
			super.init(pageSite);
			ActionRegistry registry = getActionRegistry();
			IActionBars bars = pageSite.getActionBars();
			// UNDO
			String id = ActionFactory.UNDO.getId();
			bars.setGlobalActionHandler(id, registry.getAction(id));
			// REDO
			id = ActionFactory.REDO.getId();
			bars.setGlobalActionHandler(id, registry.getAction(id));
			// DELETE
			id = ActionFactory.DELETE.getId();
			bars.setGlobalActionHandler(id, registry.getAction(id));

			id = ActionFactory.SELECT_ALL.getId();
			bars.setGlobalActionHandler(id, registry.getAction(id));

			bars.updateActionBars();
		}

		@Override
		public void createControl(Composite parent) {
			sash = new SashForm(parent, SWT.VERTICAL);

			getViewer().createControl(sash);
			getViewer().setEditDomain(getEditDomain());
			getViewer().setEditPartFactory(
					new StrutsConfigTreeEditPartFactory());
			getViewer().setContents(root);
			getSelectionSynchronizer().addViewer(getViewer());

			Canvas canvas = new Canvas(sash, SWT.BORDER);

			LightweightSystem lws = new LightweightSystem(canvas);

			ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart) getGraphicalViewer()
					.getRootEditPart();
			thumbnail = new ScrollableThumbnail((Viewport) (rootEditPart)
					.getFigure());
			thumbnail.setSource(rootEditPart
					.getLayer(LayerConstants.PRINTABLE_LAYERS));
			lws.setContents(thumbnail);

			disposeListener = new DisposeListener() {
				public void widgetDisposed(DisposeEvent e) {
					if (thumbnail != null) {
						thumbnail.deactivate();
						thumbnail = null;
					}
				}
			};
			getGraphicalViewer().getControl().addDisposeListener(
					disposeListener);

			getSite().setSelectionProvider(getViewer());

			getViewer().addSelectionChangedListener(
					new ISelectionChangedListener() {
						public void selectionChanged(SelectionChangedEvent e) {
							ISelection sel = e.getSelection();
							if (sel == null
									|| !(sel instanceof IStructuredSelection)) {
								return;
							}
							openAction.update((IStructuredSelection) sel);
						}
					});

			// double-click
			getViewer().getControl().addMouseListener(new MouseAdapter() {
				@Override
				public void mouseDoubleClick(MouseEvent e) {
					openAction.run();
				}

			});

			// create context menu
			MenuManager menu = new MenuManager();
			getViewer().setContextMenu(menu);

			menu.add(openAction);
			menu.add(new Separator());
			menu.add(getAction(ActionFactory.DELETE.getId()));

		}

		@Override
		public Control getControl() {
			return sash;
		}

		@Override
		public void dispose() {
			getSelectionSynchronizer().removeViewer(getViewer());
			if ((getGraphicalViewer().getControl() != null)
					&& !getGraphicalViewer().getControl().isDisposed()) {
				getGraphicalViewer().getControl().removeDisposeListener(
						disposeListener);
			}
			super.dispose();
		}

		private class OpenAction extends Action {
			private Object target;

			public OpenAction() {
				super(resource.getString("outline.menu.strutsJump"));
				this.target = null;
			}

			public void update(IStructuredSelection sel) {
				target = sel.getFirstElement();
				if (sel.size() == 1 && !(target instanceof RootTreeEditPart)) {
					setEnabled(true);
				} else {
					target = null;
					setEnabled(false);
				}
			}

			@Override
			public void run() {
				if (target instanceof ActionTreeEditPart) {
					String path = ((ActionModel) ((ActionTreeEditPart) target)
							.getModel()).getPath();
					setFocus(editor, "/struts-config/action-mappings/action", "path", path);
				} else if (target instanceof ForwardTreeEditPart) {
					String name = ((ForwardModel) ((ForwardTreeEditPart) target)
							.getModel()).getName();
					setFocus(editor, "/struts-config/action-mappings/action/forward", "name", name);
				} else if (target instanceof DirectForwardTreeEditPart) {
					DirectForwardModel model = (DirectForwardModel) ((DirectForwardTreeEditPart) target).getModel();
					ActionModel actionModel = (ActionModel) model.getSource();
					String forward = actionModel.getForward();
					setFocus(editor, "/struts-config/action-mappings/action", "forward", forward);
				} else if (target instanceof ExceptionTreeEditPart) {
					String type = ((ExceptionModel) ((ExceptionTreeEditPart) target)
							.getModel()).getType();
					setFocus(editor, "/struts-config/action-mappings/action/exception", "type", type);
				} else if (target instanceof IncludeTreeEditPart) {
					IncludeModel model = (IncludeModel) ((IncludeTreeEditPart) target).getModel();
					ActionModel actionModel = (ActionModel) model.getTarget();
					String include = actionModel.getPath() + ".do";
					setFocus(editor, "/struts-config/action-mappings/action", "include", include);
				} else if (target instanceof InputTreeEditPart) {
					InputModel model = (InputModel) ((InputTreeEditPart) target).getModel();
					ActionModel actionModel = (ActionModel) model.getTarget();
					String input = actionModel.getInput();
					setFocus(editor, "/struts-config/action-mappings/action", "input", input);
				} else if (target instanceof PageTreeEditPart) {
				
				}
			}
			private boolean setFocus(MultiPageStrutsConfigEditor editor, String tagName, String attrName,
		            String targetAttrValue) {
				StrutsConfigXMLEditor xmlEditor = (StrutsConfigXMLEditor) editor.getXMLEditor();
				if (xmlEditor.setFocusAttrValue(tagName, attrName, targetAttrValue)) {
					editor.setActivePage(2);
					editor.setFocus();
					return true;
				}
				Util.openAlertDialog(Util.createMessage(resource
	                    .getString("error.notexists"),
	                    new String[] { "/" + tagName + "/" +  attrName + "=" + targetAttrValue}));
				return false;
			}
		}
	}
}
