package tk.eclipse.plugin.struts.editors;

import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;

public class GraphicalStrutsConfigEditorContributer extends ActionBarContributor {

	public GraphicalStrutsConfigEditorContributer() {
		super();
	}

	protected void buildActions() {
	    addRetargetAction(new UndoRetargetAction());
	    addRetargetAction(new RedoRetargetAction());
	    addRetargetAction(new DeleteRetargetAction());
	    addRetargetAction(new ZoomInRetargetAction());
	    addRetargetAction(new ZoomOutRetargetAction());
	}

	public void setActiveEditor(IEditorPart editor) {
		ActionRegistry registry = (ActionRegistry)editor.getAdapter(ActionRegistry.class);
		if(registry!=null){
		    getActionBars().setGlobalActionHandler(
			    	ActionFactory.PRINT.getId(),
			    	registry.getAction(ActionFactory.PRINT.getId()));
			
		    super.setActiveEditor(editor);
		}
	}
	
	public void contributeToToolBar(IToolBarManager toolBarManager) {
		super.contributeToToolBar(toolBarManager);
//	    toolBarManager.add(getAction(ActionFactory.DELETE.getId()));
//	    toolBarManager.add(getAction(ActionFactory.UNDO.getId()));
//	    toolBarManager.add(getAction(ActionFactory.REDO.getId()));
		
	    toolBarManager.add(getActionRegistry().getAction(GEFActionConstants.ZOOM_IN));
	    toolBarManager.add(getActionRegistry().getAction(GEFActionConstants.ZOOM_OUT));
	}
	
//	public IAction getRetargetAction(String id){
//		return getAction(id);
//	}
	
	protected void declareGlobalActionKeys() {
	}
}
