package tk.eclipse.plugin.struts.editors;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.commands.Command;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;

import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditorContributer;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

public class MultiPageEditorContributor extends MultiPageEditorActionBarContributor {
	
	private IEditorPart activeEditorPart;
	private HTMLSourceEditorContributer textContributor = new HTMLSourceEditorContributer();
	private GraphicalStrutsConfigEditorContributer flowContributor = new GraphicalStrutsConfigEditorContributer();
	private SubActionBars textActionBars;
	private SubActionBars flowActionBars;
	
	private static final String DELETE_COMMAND_ID = "org.eclipse.ui.edit.delete";
	private static final String UNDO_COMMAND_ID   = "org.eclipse.ui.edit.undo";
	private static final String REDO_COMMAND_ID   = "org.eclipse.ui.edit.redo";
	
	public MultiPageEditorContributor() {
		super();
		textContributor.addActionId(XMLEditor.ACTION_ESCAPE_XML);
		textContributor.addActionId(XMLEditor.ACTION_COMMENT);
	}
	
	public void init(IActionBars bars, IWorkbenchPage page) {
		flowActionBars = new SubActionBars(bars);
		flowContributor.init(flowActionBars,page);
		super.init(bars, page);
	}
	
	public void init(IActionBars bars) {
		textActionBars = new SubActionBars(bars);
		textContributor.init(textActionBars);
		super.init(bars);
	}
	
	public void setActiveEditor(IEditorPart part) {
		flowContributor.setActiveEditor(part);
		activeEditorPart = null;
		super.setActiveEditor(part);
	}
	
	public void setActivePage(IEditorPart part) {
		if(activeEditorPart == part){
			return;
		}
		activeEditorPart = part;
		getActionBars().clearGlobalActionHandlers();
		getActionBars().updateActionBars();
		
		if(part instanceof StrutsConfigXMLEditor){
			textContributor.setActiveEditor(part);
			textActionBars.activate();
			setGlobalActionHandlers(textActionBars);
			
			setCommandHandler(DELETE_COMMAND_ID,
					textContributor.getActionBars().getGlobalActionHandler(ActionFactory.DELETE.getId()));
			setCommandHandler(UNDO_COMMAND_ID,
					textContributor.getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId()));
			setCommandHandler(REDO_COMMAND_ID,
					textContributor.getActionBars().getGlobalActionHandler(ActionFactory.REDO.getId()));
		} else {
			textActionBars.deactivate();
		}
		
		if(part instanceof GraphicalStrutsConfigEditor){
			flowContributor.setActiveEditor(part);
			flowActionBars.activate();
			setGlobalActionHandlers(flowActionBars);
			
			setCommandHandler(DELETE_COMMAND_ID,
					flowContributor.getActionBars().getGlobalActionHandler(ActionFactory.DELETE.getId()));
			setCommandHandler(UNDO_COMMAND_ID,
					flowContributor.getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId()));
			setCommandHandler(REDO_COMMAND_ID,
					flowContributor.getActionBars().getGlobalActionHandler(ActionFactory.REDO.getId()));
		} else {
			flowActionBars.deactivate();
		}
		
		getActionBars().updateActionBars();
	}
	
	private void setCommandHandler(String id,IAction action){
		ICommandService service = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
		Command command = service.getCommand(id);
		if(action!=null){
			command.setHandler(new org.eclipse.jface.commands.ActionHandler(action));
		} else {
			command.setHandler(null);
		}		
	}
	
	private void setGlobalActionHandlers(SubActionBars bar){
		Map<?, ?> handlers = bar.getGlobalActionHandlers();
		if (handlers != null) {
			Set<?> keys = handlers.keySet();
			for (Iterator<?> iter = keys.iterator(); iter.hasNext();) {
				String id = (String) iter.next();
				getActionBars().setGlobalActionHandler(id, (IAction) handlers.get(id));
			}
		}
		getActionBars().updateActionBars();
	}

	
	public void dispose() {
		textContributor.dispose();
		flowContributor.dispose();
		textActionBars.dispose();
		super.dispose();
	}
}
