package tk.eclipse.plugin.struts.editors;

import org.eclipse.core.resources.IProject;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.editparts.ActionEditPart;
import tk.eclipse.plugin.struts.editors.models.ActionModel;

/**
 * 
 * @author Naoki Takezoe
 * @since 2.0.6
 */
public class RunOnServerAction extends Action {
	
	private GraphicalViewer viewer;
	private IProject project;
	private String path;
	
	public RunOnServerAction(IProject project, GraphicalViewer viewer){
		super(StrutsPlugin.getResourceString("action.runOnServer"),
				StrutsPlugin.getDefault().getImageRegistry().getDescriptor(StrutsPlugin.ICON_RUN));
		this.project = project;
		this.viewer = viewer;
	}
	
	public void update(){
		this.path = getSelectedActionPath();
		if(this.path == null){
			setEnabled(false);
		} else {
			setEnabled(true);
		}
	}
	
	private String getSelectedActionPath(){
		try {
			ISelection sel = viewer.getSelection();
			if(sel instanceof IStructuredSelection){
				Object obj = ((IStructuredSelection) sel).getFirstElement();
				if(obj instanceof ActionEditPart){
					ActionModel model = (ActionModel)((ActionEditPart) obj).getModel();
					return model.getPath();
				}
			}
		} catch(Exception ex){
			Util.logException(ex);
		}
		return null;
	}

	public void run() {
		StrutsPlugin.runAction(project, path + ".do");
	}

}
