package tk.eclipse.plugin.struts.editors;

import java.util.ArrayList;
import java.util.List;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IFileEditorInput;

import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.struts.FormInfo;
import tk.eclipse.plugin.struts.PropertyInfo;
import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.xmleditor.editors.XMLAssistProcessor;
import tk.eclipse.plugin.xmleditor.editors.XMLConfiguration;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

/**
 * XML Editor for Validator configuration files.
 * This editor provides following additinal features.
 * <ul>
 *   <li>code completion for form-name (form@name)</li>
 *   <li>code completion for form-property (field@property)</li>
 *   <li>code completion for validation rule-name (field@depends)</li>
 * </ul>
 * 
 * Now, this editor validate a document based on DTD only.
 * But in the future, will support validation to these attribute values.
 * 
 * @author Naoki Takezoe
 */
public class ValidatorXMLEditor extends XMLEditor {
	
	private static final String[] CLASS_ATTRIBUTES = {
		"classname"
	};
	
	public ValidatorXMLEditor(){
		super(new ValidatorConfiguration());
		addDTDResolver(new StrutsConfigResolver());
		setValidation(false);
	}
	
	public String[] getClassNameAttributes() {
		return CLASS_ATTRIBUTES;
	}
	
	/**
	 * SourceEditor Configuration for the Validator Editor.
	 */
	private static class ValidatorConfiguration extends XMLConfiguration {
		
		public ValidatorConfiguration(){
			super(HTMLPlugin.getDefault().getColorProvider());
		}
		
		protected HTMLAssistProcessor createAssistProcessor() {
			return new ValidatorAssistProcessor();
		}
	}
	
	/**
	 * AssistProcessor for Validator configuration files.
	 */
	private static class ValidatorAssistProcessor extends XMLAssistProcessor {
		
		private String moduleName;
		private StrutsProject project = null;
		private List<String> ruleNames = new ArrayList<String>();
		
		protected AssistInfo[] getAttributeValues(String tagName, String value, AttributeInfo info) {
			// form-name
			if(tagName.equals("form") && info.getAttributeName().equals("name")){
				FormInfo[] forms = project.getActionForms(this.moduleName);
				AssistInfo[] assist = new AssistInfo[forms.length];
				for(int i=0;i<assist.length;i++){
					assist[i] = new AssistInfo(
							forms[i].getFormName(),
							forms[i].getFormName() + " - " + forms[i].getClassName(),
							StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_BEAN));
				}
				return assist;
			}
			
			// indexedListProperty
			if(tagName.equals("field") && info.getAttributeName().equals("indexedListProperty")){
				// get form element
				FuzzyXMLElement element = getOffsetElement();
				while(!element.getName().equals("form")){
					element = (FuzzyXMLElement)element.getParentNode();
					if(element == null){
						break;
					}
				}
				if(element != null){
					String formName = element.getAttributeNode("name").getValue();
					FormInfo[] forms = project.getActionForms(this.moduleName);
					String[] dim = value.indexOf('.') >=0 ? (value + " ").split("\\.") : new String[]{value};
					for(int i = 0; i < forms.length; i++){
						if(forms[i].getFormName().equals(formName)){
							PropertyInfo[] properties = forms[i].getProperties();
							List<AssistInfo> assist = new ArrayList<AssistInfo>();
							StringBuffer sb = new StringBuffer();
							for(int k = 0; k < dim.length; k++){
								for(int j = 0; j < properties.length; j++){
									if(k == dim.length - 1){
										assist.add(new AssistInfo(
												sb.toString() + properties[j].getPropertyName(),
												properties[j].getPropertyName() + " - " + properties[j].getPropertyType(),
												StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_PROPERTY)));
									}
									else if(properties[j].getPropertyName().equals(dim[k].trim())){
										sb.append(properties[j].getPropertyName()).append(".");
										properties = properties[j].getProperties();
										j = 0;
									}
								}
							}
							return (AssistInfo[]) assist.toArray(new AssistInfo[assist.size()]);
						}
					}
				}
			}
			
			// form-properties
			if(tagName.equals("field") && info.getAttributeName().equals("property")){
				// get form element
				FuzzyXMLElement element = getOffsetElement();
				while(!element.getName().equals("form")){
					element = (FuzzyXMLElement) element.getParentNode();
					if(element == null){
						break;
					}
				}
				if(element != null){
					String formName = element.getAttributeNode("name").getValue();
					FormInfo[] forms = project.getActionForms(this.moduleName);
					String[] dim = value.indexOf('.') >=0 ? (value + " ").split("\\.") : new String[]{value};
					for(int i = 0; i < forms.length; i++){
						if(forms[i].getFormName().equals(formName)){
							PropertyInfo[] properties = null;
							
							FuzzyXMLAttribute list = getOffsetElement().getAttributeNode("indexedListProperty");
							if(list == null){
								properties = forms[i].getProperties();
							} else {
								PropertyInfo listProperty = forms[i].getProperty(list.getValue());
								if(listProperty != null){
									properties = listProperty.getListProperties();
								}
							}
							
							List<AssistInfo> assist = new ArrayList<AssistInfo>();
							StringBuffer sb = new StringBuffer();
							for(int k = 0; k < dim.length; k++){
								for(int j = 0; j < properties.length; j++){
									if(k == dim.length - 1){
										assist.add(new AssistInfo(
												sb.toString() + properties[j].getPropertyName(),
												properties[j].getPropertyName() + " - " + properties[j].getPropertyType(),
												StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_PROPERTY)));
									}
									else if(properties[j].getPropertyName().equals(dim[k].trim())){
										sb.append(properties[j].getPropertyName()).append(".");
										properties = properties[j].getProperties();
										j = 0;
									}
								}
							}
							return (AssistInfo[]) assist.toArray(new AssistInfo[assist.size()]);
						}
					}
				}
			}
			// rule-name
			if(tagName.equals("field") && info.getAttributeName().equals("depends")){
				AssistInfo[] assist = new AssistInfo[ruleNames.size()];
				String pre = "";
				if(value.indexOf(",")>=0){
					// get last word
					StringBuffer sb = new StringBuffer();
					for(int i=0;i<value.length();i++){
						char c = value.charAt(i);
						if(Character.isJavaIdentifierPart(c) || c=='.'){
							sb.append(c);
						} else {
							sb.setLength(0);
						}
					}
					String lastWord = sb.toString();
					pre  = value.substring(0,value.length()-lastWord.length());
				}
				for(int i=0;i<assist.length;i++){
					assist[i] = new AssistInfo(pre + (String)ruleNames.get(i),(String)ruleNames.get(i));
				}
				return assist;
			}
			return super.getAttributeValues(tagName, value, info);
		}
		
		public void update(HTMLSourceEditor editor, String source) {
			super.update(editor, source);
			if(editor.getEditorInput() instanceof IFileEditorInput){
				IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
				this.project = new StrutsProject(input.getFile().getProject());
				
				String[] modules = this.project.getModuleNames();
				this.moduleName = "";
				for(int i=0;i<modules.length;i++){
					IFile[] files = project.getValidatorXML(modules[i]);
					for(int j=0;j<files.length;j++){
						if(files[j].equals(input.getFile())){
							this.moduleName = modules[i];
							break;
						}
					}
				}
				
				ruleNames.clear();
				String[] rules = Util.getValidatorRules(project, this.moduleName);
				for(int i=0;i<rules.length;i++){
					ruleNames.add(rules[i]);
				}
			}
		}
		
	}
}
