package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.ReconnectRequest;

import tk.eclipse.plugin.struts.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.struts.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.struts.editors.models.AbstractModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;


public abstract class AbstractEntityEditPart extends AbstractStrutsConfigEditPart implements NodeEditPart {
	
	private IFile file;
	
	public AbstractEntityEditPart(IFile file){
		this.file = file;
	}
	
	public IFile getFile(){
		return this.file;
	}
	
	protected void refreshVisuals() {
		Object model = getModel();
		if(model instanceof AbstractEntityModel){
			Rectangle constraint = ((AbstractEntityModel)model).getConstraint();
			((GraphicalEditPart) getParent()).setLayoutConstraint(this,getFigure(), constraint);
		}
	}
	
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE,new EntityComponentEditPolicy());
		installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE,new NodeEditPolicy());
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals(AbstractEntityModel.P_CONSTRAINT)){
			refreshVisuals();
		} else if(evt.getPropertyName().equals(AbstractEntityModel.P_SOURCE_CONNECTION)){
			refreshSourceConnections();
		} else if(evt.getPropertyName().equals(AbstractEntityModel.P_TARGET_CONNECTION)){
			refreshTargetConnections();
		}
	}
	
	protected List getModelSourceConnections() {
		return ((AbstractEntityModel) getModel()).getModelSourceConnections();
	}
	
	protected List getModelTargetConnections() {
		return ((AbstractEntityModel) getModel()).getModelTargetConnections();
	}
	
	public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
		return new ChopboxAnchor(getFigure());
	}
	
	public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
		return new ChopboxAnchor(getFigure());
	}
	
	public ConnectionAnchor getSourceConnectionAnchor(Request request) {
		return new ChopboxAnchor(getFigure());
	}
	
	public ConnectionAnchor getTargetConnectionAnchor(Request request) {
		return new ChopboxAnchor(getFigure());
	}
	
	/** EditPolicy for entities. */
	private class EntityComponentEditPolicy extends ComponentEditPolicy {
		protected Command createDeleteCommand(GroupRequest deleteRequest) {
			DeleteCommand command = new DeleteCommand();
			command.setRootModel(getHost().getParent().getModel());
			command.setTargetModel(getHost().getModel());
			return command;
		}
	}
	/** EditPolicy for connections. */
	private class NodeEditPolicy extends GraphicalNodeEditPolicy {
		
		protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
			AbstractConnectionModel conn = ((CreateConnectionCommand)request.getStartCommand()).getConnectionModel();
			AbstractEntityModel model = (AbstractEntityModel)getHost().getModel();
			if(!model.canTarget(conn)){
				return null;
			}
			CreateConnectionCommand command = (CreateConnectionCommand) request.getStartCommand();
			command.setTarget(model);
			return command;
		}
		
		protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
			AbstractConnectionModel conn = (AbstractConnectionModel)request.getNewObject();
			AbstractEntityModel model = (AbstractEntityModel)getHost().getModel();
			if(!model.canSource(conn)){
				return null;
			}
			CreateConnectionCommand command = new CreateConnectionCommand();
			command.setConnection(conn);
			command.setSource(model);
			request.setStartCommand(command);
			return command;
		}
		
		protected Command getReconnectTargetCommand(ReconnectRequest request) {
			AbstractConnectionModel conn = (AbstractConnectionModel)request.getConnectionEditPart().getModel();
			AbstractEntityModel model = (AbstractEntityModel)getHost().getModel();
			if(!model.canTarget(conn)){
				return null;
			}
			ReconnectTargetCommand command = new ReconnectTargetCommand();
			command.setConnection(conn);
			command.setTarget(model);
			return command;
		}
		
		protected Command getReconnectSourceCommand(ReconnectRequest request) {
			AbstractConnectionModel conn = (AbstractConnectionModel)request.getConnectionEditPart().getModel();
			AbstractEntityModel model = (AbstractEntityModel)getHost().getModel();
			if(!model.canSource(conn)){
				return null;
			}
			ReconnectSourceCommand command = new ReconnectSourceCommand();
			command.setConnection(conn);
			command.setSource(model);
			return command;
		}
	}
	
	/** Delete command. */
	private class DeleteCommand extends Command {
		
		private RootModel root;
		private AbstractModel model;
		private List sourceConnections = new ArrayList();
		private List targetConnections = new ArrayList();
		
		public void execute() {
			sourceConnections.addAll(((AbstractEntityModel) model).getModelSourceConnections());
			targetConnections.addAll(((AbstractEntityModel) model).getModelTargetConnections());
			for (int i = 0; i < sourceConnections.size(); i++) {
				AbstractConnectionModel model = (AbstractConnectionModel) sourceConnections.get(i);
				model.detachSource();
				model.detachTarget();
			}
			for (int i = 0; i < targetConnections.size(); i++) {
				AbstractConnectionModel model = (AbstractConnectionModel) targetConnections.get(i);
				model.detachSource();
				model.detachTarget();
			}
			root.removeChild(model);
		}
		public void setRootModel(Object root) {
			this.root = (RootModel) root;
		}
		public void setTargetModel(Object model) {
			this.model = (AbstractModel) model;
		}
		public void undo(){
			root.addChild(model);
			for (int i = 0; i < sourceConnections.size(); i++) {
				AbstractConnectionModel model = (AbstractConnectionModel) sourceConnections.get(i);
				model.attachSource();
				model.attachTarget();
			}
			for (int i = 0; i < targetConnections.size(); i++) {
				AbstractConnectionModel model = (AbstractConnectionModel) targetConnections.get(i);
				model.attachSource();
				model.attachTarget();
			}
			sourceConnections.clear();
			targetConnections.clear();			
		}
	}	
	/** Create connection command. */
	private class CreateConnectionCommand extends Command {
		private AbstractEntityModel source;
		private AbstractEntityModel target;
		private AbstractConnectionModel connection;
		
		public AbstractConnectionModel getConnectionModel(){
			return connection;
		}
		
		public boolean canExecute() {
			if (source == null || target == null){
				return false;
			}
			return true;
		}
		
		public void execute() {
			connection.attachSource();
			connection.attachTarget();
		}
		
		public void setConnection(Object model) {
			connection = (AbstractConnectionModel) model;
		}
		
		public void setSource(Object model) {
			source = (AbstractEntityModel) model;
			connection.setSource(source);
		}
		
		public void setTarget(Object model) {
			target = (AbstractEntityModel) model;
			connection.setTarget(target);
		}
		
		public void undo() {
			connection.detachSource();
			connection.detachTarget();
		}
	}
	/** Re-connect target command. */
	private class ReconnectTargetCommand extends Command {
		private AbstractEntityModel target;
		private AbstractEntityModel oldTarget;
		private AbstractConnectionModel connection;
		
		public void execute() {
			connection.detachTarget();
			connection.setTarget(target);
			connection.attachTarget();
		}
		
		public void setConnection(Object model) {
			connection = (AbstractConnectionModel) model;
			oldTarget = connection.getTarget();
		}
		
		public void setTarget(Object model) {
			target = (AbstractEntityModel) model;
		}
		
		public boolean canExecute() {
			if (connection.getSource() == null || target == null){
				return false;
			}
			return true;
		}
		
		public void undo() {
			connection.detachTarget();
			connection.setTarget(oldTarget);
			connection.attachTarget();
		}
	}
	/** Re-connect source command. */
	private class ReconnectSourceCommand extends Command {
		private AbstractEntityModel source;
		private AbstractEntityModel oldSource;
		private AbstractConnectionModel connection;
		
		public void execute() {
			connection.detachSource();
			connection.setSource(source);
			connection.attachSource();
		}
		
		public void setConnection(Object model) {
			connection = (AbstractConnectionModel) model;
			oldSource = connection.getSource();
		}
		
		public void setSource(Object model) {
			source = (AbstractEntityModel) model;
		}
		
		public boolean canExecute() {
			if (connection.getTarget() == null || source == null){
				return false;
			}
			return true;
		}
		
		public void undo() {
			connection.detachSource();
			connection.setSource(oldSource);
			connection.attachSource();
		}
	}
}
