package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.GroupRequest;

import tk.eclipse.plugin.struts.editors.ConnectoinBendpoint;
import tk.eclipse.plugin.struts.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.struts.editors.models.AbstractModel;
import tk.eclipse.plugin.struts.editors.models.InputModel;

public abstract class AbstractStrutsConnectionEditPart extends AbstractConnectionEditPart implements PropertyChangeListener {
	
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE,new EntityComponentEditPolicy());
		installEditPolicy(EditPolicy.CONNECTION_ENDPOINTS_ROLE,new ConnectionEndpointEditPolicy());
		installEditPolicy(EditPolicy.CONNECTION_BENDPOINTS_ROLE,new ConnectionBendpointEditPolicy());
	}
	
	public void activate() {
		super.activate();
		((AbstractModel) getModel()).addPropertyChangeListener(this);
	}
	
	public void deactivate() {
		super.deactivate();
		((AbstractModel) getModel()).removePropertyChangeListener(this);
	}
	
	/**
	 * Adds default bend-points when the source model equals the target model.
	 */
	protected void addDefaultBendpoints(){
		AbstractConnectionModel model = (AbstractConnectionModel)getModel();
		if(model.getSource()==model.getTarget() && ((AbstractConnectionModel) getModel()).getBendpoints().size()==0){
            model.addBendpoint(0, new ConnectoinBendpoint(new Dimension(-40, -40), new Dimension(-40, -40)));
            model.addBendpoint(0, new ConnectoinBendpoint(new Dimension(0, -60), new Dimension(0, -60)));
		}
	}
	
	/** EditPolicy for entities. */
	private class EntityComponentEditPolicy extends ComponentEditPolicy {
		protected Command createDeleteCommand(GroupRequest deleteRequest) {
			DeleteCommand command = new DeleteCommand();
			command.setModel((AbstractConnectionModel)getModel());
			//command.setTargetModel(getHost().getModel());
		    return command;
		}
	}
	
	/** Delete connection command. */
	private class DeleteCommand extends Command {
		private AbstractConnectionModel model;
		public void setModel(AbstractConnectionModel model){
			this.model = model;
		}
		public void execute() {
			model.detachSource();
			model.detachTarget();
		}
		public void undo() {
			model.attachSource();
			model.attachTarget();
		}
	}
	
	/** EditPolicy for Bendpoints */
	private class ConnectionBendpointEditPolicy extends BendpointEditPolicy {
		
		protected Command getCreateBendpointCommand(BendpointRequest request) {
            CreateBendpointCommand com = new CreateBendpointCommand();
            Point p = request.getLocation();
            Connection conn = getConnection();
            
            conn.translateToRelative(p);

            com.setLocation(p);
            Point ref1 = getConnection().getSourceAnchor().getReferencePoint();
            Point ref2 = getConnection().getTargetAnchor().getReferencePoint();

            conn.translateToRelative(ref1);
            conn.translateToRelative(ref2);

            com.setRelativeDimensions(p.getDifference(ref1), p
                    .getDifference(ref2));
            com.setConnectionModel((AbstractConnectionModel) request
                    .getSource().getModel());
            com.setIndex(request.getIndex());
            return com;
		}
		
		protected Command getDeleteBendpointCommand(BendpointRequest request) {
            BendpointCommand com = new DeleteBendpointCommand();
            Point p = request.getLocation();
            com.setLocation(p);
            com.setConnectionModel((AbstractConnectionModel) request
                    .getSource().getModel());
            com.setIndex(request.getIndex());
            return com;
		}
		
		protected Command getMoveBendpointCommand(BendpointRequest request) {
            MoveBendpointCommand com = new MoveBendpointCommand();
            Point p = request.getLocation();
            Connection conn = getConnection();

            conn.translateToRelative(p);

            com.setLocation(p);

            Point ref1 = getConnection().getSourceAnchor().getReferencePoint();
            Point ref2 = getConnection().getTargetAnchor().getReferencePoint();

            conn.translateToRelative(ref1);
            conn.translateToRelative(ref2);

            com.setRelativeDimensions(p.getDifference(ref1), p
                    .getDifference(ref2));
            com.setConnectionModel((AbstractConnectionModel) request
                    .getSource().getModel());
            com.setIndex(request.getIndex());
            return com;
		}
	}
	
    private class BendpointCommand extends Command {

        protected int index = 0;

        protected Point location = null;

        protected AbstractConnectionModel connectionModel = null;

        private Dimension d1 = null;

        private Dimension d2 = null;

        protected Dimension getFirstRelativeDimension() {
            return d1;
        }

        protected Dimension getSecondRelativeDimension() {
            return d2;
        }

        protected int getIndex() {
            return index;
        }

        protected Point getLocation() {
            return location;
        }

        protected AbstractConnectionModel getConnectionModel() {
            return connectionModel;
        }

        public void redo() {
            execute();
        }

        public void setRelativeDimensions(Dimension dim1, Dimension dim2) {
            d1 = dim1;
            d2 = dim2;
        }

        public void setIndex(int i) {
            index = i;
        }

        public void setLocation(Point p) {
            location = p;
        }

        public void setConnectionModel(AbstractConnectionModel connection) {
            connectionModel = connection;
        }
    }

	
	/** Create command for Bendpoints */
	private class CreateBendpointCommand extends BendpointCommand {
		
		public void execute() {
            ConnectoinBendpoint rbp = new ConnectoinBendpoint(
                    getFirstRelativeDimension(), getSecondRelativeDimension());
            getConnectionModel().addBendpoint(getIndex(), rbp);
            super.execute();
		}
		
		public void undo() {
			super.undo();
            getConnectionModel().removeBendpoint(getIndex());
		}
	}
	
	/** Move command for Bendpoints */
	private class MoveBendpointCommand extends BendpointCommand {
		
		private ConnectoinBendpoint oldBendpoint = null;
		
		public void execute() {
            ConnectoinBendpoint bp = new ConnectoinBendpoint(
                    getFirstRelativeDimension(), getSecondRelativeDimension());
            setOldBendpoint((ConnectoinBendpoint) getConnectionModel().getBendpoints().get(getIndex()));
            getConnectionModel().replaceBendpoint(getIndex(), bp);
            super.execute();
		}
		
        protected ConnectoinBendpoint getOldBendpoint() {
            return oldBendpoint;
        }

        public void setOldBendpoint(ConnectoinBendpoint bp) {
            oldBendpoint = bp;
        }

        public void undo() {
            super.undo();
            getConnectionModel().replaceBendpoint(getIndex(), getOldBendpoint());
        }
	}
	
	/** Delete command for Bendpoints */
	private class DeleteBendpointCommand extends BendpointCommand {
		
		private ConnectoinBendpoint bendpoint = null;
		
		public void execute() {
			// Record location of bendpoint for UNDO
			bendpoint = (ConnectoinBendpoint) getConnectionModel().getBendpoints().get(getIndex());
			getConnectionModel().removeBendpoint(getIndex());
			super.execute();
		}
		
        public void undo() {
            super.undo();
            getConnectionModel().addBendpoint(getIndex(), bendpoint);
        }
	}

	
//	public void setSelected(int value) {
//		super.setSelected(value);
//		if (value != EditPart.SELECTED_NONE){
//			((PolylineConnection)getFigure()).setLineWidth(2);
//		} else {
//			((PolylineConnection)getFigure()).setLineWidth(1);
//		}
//	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		//super.propertyChange(evt);
		String propName = evt.getPropertyName();
		if(propName.equals(InputModel.P_BEND_POINT)){
			refreshBendpoints();
			return;
		}
	}
	
	protected void refreshVisuals() {
		refreshBendpoints();
		super.refreshVisuals();
	}
	
	protected void refreshBendpoints() {
        List modelConstraint = ((AbstractConnectionModel) getModel()).getBendpoints();
		List figureConstraint = new ArrayList();
		for (int i = 0; i < modelConstraint.size(); i++) {
			ConnectoinBendpoint wbp = (ConnectoinBendpoint) modelConstraint.get(i);
			RelativeBendpoint2 rbp = new RelativeBendpoint2(getConnectionFigure());
			rbp.setRelativeDimensions(wbp.getFirstRelativeDimension(), wbp.getSecondRelativeDimension());
			rbp.setWeight((i + 1) / ((float) modelConstraint.size() + 1));
			figureConstraint.add(rbp);
		}
		getConnectionFigure().setRoutingConstraint(figureConstraint);
		
	}
	
    private class RelativeBendpoint2 extends RelativeBendpoint {

        public RelativeBendpoint2(Connection conn) {
            super(conn);
        }

        public Point getLocation() {
            Point p = super.getLocation();
            if (p.x < 5) {
                p.x = 5;
            }
            if (p.y < 5) {
                p.y = 5;
            }
            return p;
        }
    }


}
