package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;

import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Text;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.models.ActionModel;

public class ActionEditPart extends AbstractEntityEditPart {
    
	private ActionDirectEditManager directManager = null;
	
	public ActionEditPart(IFile file){
		super(file);
	}
	
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new ActionDirectEditPolicy());
	}
	
    protected IFigure createFigure() {
		ActionModel model = (ActionModel) getModel();
		String path = model.getPath();
		if(path.equals("")){
			path = "<action>";
		}
		
		Label label = new Label();
		label.setText(path);
		if(isValid()){
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_ACTION));
		} else {
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_ACTION_WARN));
		}
		label.setTextPlacement(PositionConstants.SOUTH);
		
		return label;
    }
    
	protected void refreshVisuals(){
		super.refreshVisuals();
		Label label = (Label)getFigure();
        // (MVL) simplified
		if(isValid()){
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_ACTION));
		} else {
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_ACTION_WARN));
		}
	}
    
	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
		String propName = evt.getPropertyName();
		Label label = (Label)getFigure();
		if(propName.equals(ActionModel.P_PATH)){
			String path = (String)evt.getNewValue();
			if(path.equals("")){
				path = "<action>";
			}
			label.setText(path);
		}
		
        // (MVL) simplified
		if(isValid()){
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_ACTION));
		} else {
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_ACTION_WARN));
		}
	}
    
    protected boolean isValid() {
        ActionModel model = (ActionModel) getModel();
        // (MVL) validation: exactly one of type, forward and include must be set
        boolean valid = false;
        String type = model.getType();
        String forward = model.getForward();
        String include = model.getInclude();
        if (type != null && !type.equals("")) {
            valid = exists(type) && (forward == null || forward.equals("")) &&
                (include == null || include.equals(""));
        } else if (forward != null && !forward.equals("")) {
            valid = (include == null || include.equals(""));
        } else if (include != null && !include.equals("")) {
            valid = true;
        }
        return valid;
    }
	
	public boolean exists(String className){
		try {
			if(className==null || className.equals("")){
				return false;
			}
			if(className.indexOf('{') >=0){
				return true;
			}
			IJavaProject javaProject = JavaCore.create(getFile().getProject());
			IType type = javaProject.findType(className);
			if(type.isClass() && type.exists()){
				return true;
			}
		} catch(Exception ex){
		}
		return false;
	}
	
	public void performRequest(Request req) {
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		} else if (req.getType().equals(RequestConstants.REQ_OPEN)) {
            performOpen();
            return;
		}
		super.performRequest(req);
	}
	
	private void performOpen() {
		Util.openAction(getFile().getProject(), (ActionModel)getModel());
		
//		try {
//			ActionModel model = (ActionModel)getModel();
//			IProject project = getFile().getProject();
//			
//			CommandStack stack = getViewer().getEditDomain().getCommandStack();
//			Util.openConfigurationActionWizard(JavaCore.create(project), model, stack);
//		} catch (Exception e) {
//			
//		}
	}
	
	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new ActionDirectEditManager(
						TextCellEditor.class,
						new ActionCellEditorLocator(getFigure()));
		}
		directManager.show();
	}
	
	/**
	 * DirectEditManager
	 */
	private class ActionDirectEditManager extends DirectEditManager {
		
		public ActionDirectEditManager(Class editorType,CellEditorLocator locator) {
			super(ActionEditPart.this, editorType, locator);
		}
		
		protected void initCellEditor() {
			getCellEditor().setValue(((ActionModel)getModel()).getPath());
			Text text = (Text) getCellEditor().getControl();
			text.selectAll();
		}
	}
	
	/**
	 * CellEditorLocator
	 */
	private class ActionCellEditorLocator implements CellEditorLocator {
		
		private IFigure figure;
		
		public ActionCellEditorLocator(IFigure f) {
			figure = f;
		}
		
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			//Point pref = text.computeSize(-1, -1);
			Rectangle rect = figure.getBounds().getCopy();
			figure.translateToAbsolute(rect);
			text.setBounds(rect.x, rect.y + 32, rect.width, rect.height - 32);
		}
	}
	
	/**
	 * DirectEditCommand
	 */
	private class DirectEditCommand extends Command {
		
		private String oldPath;
		private String newPath;
		
		public void execute() {
			ActionModel model = (ActionModel)getModel();
			oldPath = model.getPath();
			model.setPath(newPath);
		}
		
		public void setPath(String path) {
			newPath = path;
		}
		
		public void undo() {
			ActionModel model = (ActionModel)getModel();
			model.setPath(oldPath);
		}
	}
	
	/**
	 * DirectEditPolicy
	 */
	private class ActionDirectEditPolicy extends DirectEditPolicy {
		
		protected Command getDirectEditCommand(DirectEditRequest request) {
			DirectEditCommand command = new DirectEditCommand();
			command.setPath((String) request.getCellEditor().getValue());
			return command;
		}
		
		protected void showCurrentEditValue(DirectEditRequest request) {
		}
	}
}
