package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Text;

import tk.eclipse.plugin.htmleditor.gefutils.LabelArrowConnection;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;

/**
 * An EditPart of ForwardModel.
 * 
 * @author Naoki Takezoe
 */
public class ForwardEditPart extends AbstractStrutsConnectionEditPart {
	
	private ForwardDirectEditManager directManager;
	
	public ForwardEditPart(){
	}
	
	protected IFigure createFigure() {
		ForwardModel model = (ForwardModel)getModel();
		String name = model.getName();
		if(name.equals("")){
			name = "<forward>";
		}
		
		LabelArrowConnection connection = new LabelArrowConnection(null);
		connection.setText(name);
		addDefaultBendpoints();
		
		return connection;
	}
	
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new ForwardDirectEditPolicy());
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
		String propName = evt.getPropertyName();
		if(propName.equals(ForwardModel.P_NAME)){
			String name = (String)evt.getNewValue();
			if(name.equals("")){
				name = "<forward>";
			}
			LabelArrowConnection connection = (LabelArrowConnection)getFigure();
			connection.setText(name);
			refreshVisuals();
		}
	}
	
	public void performRequest(Request req) {
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}
	
	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new ForwardDirectEditManager(
					TextCellEditor.class,
					new ForwardCellEditorLocator(getFigure()));
		}
		directManager.show();
	}
	
	/**
	 * DirectEditManager
	 */
	private class ForwardDirectEditManager extends DirectEditManager {
		
		public ForwardDirectEditManager(Class editorType, CellEditorLocator locator) {
			super(ForwardEditPart.this, editorType, locator);
		}
		
		protected void initCellEditor() {
			getCellEditor().setValue(((ForwardModel)getModel()).getName());
			Text text = (Text) getCellEditor().getControl();
			text.selectAll();
		}
	}
	
	/**
	 * CellEditorLocator
	 */
	private class ForwardCellEditorLocator implements CellEditorLocator {
		
		private IFigure figure;
		
		public ForwardCellEditorLocator(IFigure f) {
			figure = f;
		}
		
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			//Point pref = text.computeSize(-1, -1);
			Rectangle rect = ((LabelArrowConnection)figure).getLabel().getBounds().getCopy();
			figure.translateToAbsolute(rect);
			text.setBounds(rect.x, rect.y, rect.width, rect.height);
		}
	}
	
	/**
	 * DirectEditCommand
	 */
	private class DirectEditCommand extends Command {
		
		private String oldName;
		private String newName;
		
		public void execute() {
			ForwardModel model = (ForwardModel)getModel();
			oldName = model.getName();
			model.setName(newName);
		}
		
		public void setName(String name) {
			newName = name;
		}
		
		public void undo() {
			ForwardModel model = (ForwardModel)getModel();
			model.setName(oldName);
		}
	}
	
	/**
	 * DirectEditPolicy
	 */
	private class ForwardDirectEditPolicy extends DirectEditPolicy {
		
		protected Command getDirectEditCommand(DirectEditRequest request) {
			DirectEditCommand command = new DirectEditCommand();
			command.setName((String) request.getCellEditor().getValue());
			return command;
		}
		
		protected void showCurrentEditValue(DirectEditRequest request) {
		}
	}
}
