package tk.eclipse.plugin.struts.editors.editparts;

import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.ui.IFileEditorInput;

import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.editors.GraphicalStrutsConfigEditor;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.DirectForwardModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.IncludeModel;
import tk.eclipse.plugin.struts.editors.models.InputModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class StrutsConfigEditPartFactory implements EditPartFactory {
    
    private IFile file;
    private String moduleName;
    
    public StrutsConfigEditPartFactory(GraphicalStrutsConfigEditor editor){
        
		IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
		this.file = input.getFile();
		
		this.moduleName = "";
		StrutsProject project = new StrutsProject(file.getProject());
		String[] modules = project.getModuleNames();
		for(int i=0;i<modules.length;i++){
			IFile files[] = project.getStrutsConfigXML(modules[i]);
			for(int j=0;j<files.length;j++){
				if(files[j].equals(this.file)){
					this.moduleName = modules[i];
					break;
				}
			}
		}
    }
    
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart part = null;
		if(model instanceof RootModel){
			part = new RootEditPart();
		} else if(model instanceof ActionModel){
		    part = new ActionEditPart(file);
		} else if(model instanceof PageModel){
		    part = new PageEditPart(file, moduleName);
		} else if(model instanceof ForwardModel){
		    part = new ForwardEditPart();
		} else if(model instanceof ExceptionModel){
		    part = new ExceptionEditPart();
        // (MVL) added
        } else if (model instanceof DirectForwardModel) {
            part = new DirectForwardEditPart();
        } else if (model instanceof IncludeModel) {
            part = new IncludeEditPart();
        } else if (model instanceof InputModel) {
            part = new InputEditPart();
		} else {
		    return null;
		}
		part.setModel(model);
		return part;
	}
	
//	private IFile getFile(){
//		IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
//		return input.getFile();
//	}

}
