package tk.eclipse.plugin.struts.editors.models;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.IPropertySource;

/**
 * This is a base class of entity models used in the struts-config.xml visual editor.
 */
public abstract class AbstractEntityModel extends AbstractModel implements IPropertySource {
	
	private static final long serialVersionUID = 1L;
	
	private Rectangle constraint;
	private RootModel root;
	private List<AbstractConnectionModel> sourceConnections = new ArrayList<AbstractConnectionModel>();
	private List<AbstractConnectionModel> targetConnections = new ArrayList<AbstractConnectionModel>();
	
	public static final String P_CONSTRAINT = "_constraint";
	public static final String P_SOURCE_CONNECTION = "_source_connection";
	public static final String P_TARGET_CONNECTION = "_target_connection";
	
	public RootModel getRoot() {
		return root;
	}
	
	public void setRoot(RootModel root) {
		this.root = root;
	}
	
	public Rectangle getConstraint() {
		return constraint;
	}
	
	public void setConstraint(Rectangle constraint) {
		if (constraint.x < 5) {
			constraint.x = 5;
		}
		if (constraint.y < 5) {
			constraint.y = 5;
		}
		this.constraint = constraint;
		firePropertyChange(P_CONSTRAINT, null, constraint);
	}
	
	public boolean canSource(AbstractConnectionModel conn){
		return false;
	}
	
	public boolean canTarget(AbstractConnectionModel conn){
		return false;
	}
	
	public void addSourceConnection(AbstractConnectionModel connx) {
		sourceConnections.add(connx);
		firePropertyChange(P_SOURCE_CONNECTION, null, connx);
	}
	
	public void addTargetConnection(AbstractConnectionModel connx) {
		targetConnections.add(connx);
		firePropertyChange(P_TARGET_CONNECTION, null, connx);
	}
	
	public List<AbstractConnectionModel> getModelSourceConnections() {
		return sourceConnections;
	}
	
	public List<AbstractConnectionModel> getModelTargetConnections() {
		return targetConnections;
	}
	
	public void removeSourceConnection(AbstractConnectionModel connx) {
		sourceConnections.remove(connx);
		firePropertyChange(P_SOURCE_CONNECTION, connx, null);
	}
	
	public void removeTargetConnection(AbstractConnectionModel connx) {
		targetConnections.remove(connx);
		firePropertyChange(P_TARGET_CONNECTION, connx, null);
	}
	
	public boolean equals(Object obj){
		throw new RuntimeException("equals is not implemented!");
	}
}