package tk.eclipse.plugin.struts.editors.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

import tk.eclipse.plugin.htmleditor.gefutils.TextAreaPropertyDescriptor;
import tk.eclipse.plugin.struts.StrutsPlugin;

/**
 * This is a base class of all GEF models.
 */
abstract public class AbstractModel implements Serializable, IPropertySource {
	
	private static final long serialVersionUID = 1L;
	
	public static final String P_COMMENT = "_comment";
	private String comment = "";
	
	private transient Map<String, IPropertyDescriptor> descriptors = new HashMap<String, IPropertyDescriptor>();
	
	public AbstractModel(){
		if(hasComment()){
			addPropertyDescriptor(P_COMMENT, new TextAreaPropertyDescriptor(P_COMMENT, "comment"));
		}
	}
	
	protected boolean hasComment(){
		return true;
	}
	
	protected void addPropertyDescriptor(String id, IPropertyDescriptor descriptor){
		this.descriptors.put(id, descriptor);
	}
	
	public void setComment(String comment){
		this.comment = comment;
		firePropertyChange(P_COMMENT, null, comment);
	}
	
	public String getComment(){
		return this.comment;
	}
	
	private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		listeners.addPropertyChangeListener(listener);
	}

	public synchronized void firePropertyChange(String propName, Object oldValue,Object newValue) {
		if(StrutsPlugin.getDefault().canFirePropertyChangeEvent()){
			listeners.firePropertyChange(propName, oldValue, newValue);
		}
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		listeners.removePropertyChangeListener(listener);
	}
	
	public IPropertyDescriptor[] getPropertyDescriptors() {
		return this.descriptors.values().toArray(new IPropertyDescriptor[this.descriptors.size()]);
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_COMMENT)){
			return getComment();
		}
		return null;
	}
	
	public boolean isPropertySet(Object id) {
		return this.descriptors.containsKey(id);
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_COMMENT)){
			setComment((String)value);
		}
	}
	
	public void resetPropertyValue(Object id) {
	}
	
	public Object getEditableValue() {
		return this;
	}

}