package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.struts.properties.Properties;
import tk.eclipse.plugin.struts.properties.PropertiesPropertyDescriptor;

public class DataSourceModel extends AbstractModel implements IPropertySource {

	private static final long serialVersionUID = 2118310686193226947L;
	
	private String id = "";
	private String type = "";
	private String className = "";
	private String key = "";
	private Properties properties = new Properties();
	
	public static final String P_ID = "_id";
	public static final String P_TYPE = "_type";
	public static final String P_CLASSNAME = "_classname";
	public static final String P_KEY = "_key";
	public static final String P_PROPERTIES = "_properties";
	
	public DataSourceModel(){
		addPropertyDescriptor(P_TYPE, new TextPropertyDescriptor(P_TYPE,"type"));
		addPropertyDescriptor(P_CLASSNAME, new TextPropertyDescriptor(P_CLASSNAME,"className"));
		addPropertyDescriptor(P_KEY, new TextPropertyDescriptor(P_KEY,"key"));
		addPropertyDescriptor(P_PROPERTIES, new PropertiesPropertyDescriptor(P_PROPERTIES,"properties"));
		addPropertyDescriptor(P_ID, new TextPropertyDescriptor(P_ID,"id"));
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public String getClassName() {
		return className;
	}
	
	public void setClassName(String className) {
		this.className = className;
		firePropertyChange(P_CLASSNAME,null,className);
	}
	
	public String getKey() {
		return key;
	}
	
	public void setKey(String key) {
		this.key = key;
		firePropertyChange(P_KEY,null,key);
	}
	
	public String getType() {
		return type;
	}
	
	public void setType(String type) {
		this.type = type;
		firePropertyChange(P_TYPE,null,type);
	}
	
	public Object getEditableValue() {
		return this;
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_TYPE)){
			return getType();
		} else if(id.equals(P_CLASSNAME)){
			return getClassName();
		} else if(id.equals(P_KEY)){
			return getKey();
		} else if(id.equals(P_PROPERTIES)){
			return getProperties();
		} else if(id.equals(P_ID)){
			return getId();
		}
		return super.getPropertyValue(id);
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_TYPE)){
			setType((String)value);
		} else if(id.equals(P_CLASSNAME)){
			setClassName((String)value);
		} else if(id.equals(P_KEY)){
			setKey((String)value);
		} else if(id.equals(P_PROPERTIES)){
			setProperties((Properties)value);
		} else if(id.equals(P_ID)){
			setId((String)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public Properties getProperties() {
		return properties;
	}
	
	public void setProperties(Properties properties) {
		this.properties = properties;
		firePropertyChange(P_PROPERTIES,null,properties);
	}
	
	public boolean equals(Object obj){
		if(obj instanceof DataSourceModel){
			DataSourceModel model = (DataSourceModel)obj;
			if(model.getProperties().equals(getProperties())){
				return true;
			}
		}
		return false;
	}
}
