package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;
import tk.eclipse.plugin.htmleditor.gefutils.TextAreaPropertyDescriptor;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.properties.Properties;
import tk.eclipse.plugin.struts.properties.PropertiesPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.ScopePropertyDescriptor;

public class GlobalExceptionModel extends AbstractModel implements IPropertySource {
	
	private static final long serialVersionUID = -5208223814255783012L;
	
	private String id        = "";
	private String bundle    = "";
	private String type      = "";
	private String path      = "";
	private String key       = "";
	private String handler   = "";
	private String className = "";
	private String scope     = "";
	private Properties properties = new Properties();
	
	public static final String P_ID         = "_id";
	public static final String P_BUNDLE     = "_bundle";
	public static final String P_TYPE       = "_type";
	public static final String P_PATH       = "_path";
	public static final String P_KEY        = "_key";
	public static final String P_HANDLER    = "_handler";
	public static final String P_SCOPE      = "_scope";
	public static final String P_CLASS_NAME = "_class_name";
	public static final String P_PROPERTIES = "_properties";
	
	private RootModel root;
	
	public RootModel getRoot() {
		return root;
	}
	
	public void setRoot(RootModel root) {
		this.root = root;
	}
	
	public String getBundle() {
		return bundle;
	}
	
	public void setBundle(String bundle) {
		this.bundle = bundle;
		firePropertyChange(P_BUNDLE,null,bundle);
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public Properties getProperties() {
		return properties;
	}
	
	public void setProperties(Properties properties) {
		this.properties = properties;
		firePropertyChange(P_PROPERTIES,null,properties);
	}
	
	public String getClassName() {
		return className;
	}
	
	public void setClassName(String className) {
		this.className = className;
		firePropertyChange(P_CLASS_NAME,null,className);
	}
	
	public String getHandler() {
		return handler;
	}
	
	public void setHandler(String handler) {
		this.handler = handler;
		firePropertyChange(P_HANDLER,null,handler);
	}
	
	public String getScope() {
		return scope;
	}
	
	public void setScope(String scope) {
		this.scope = scope;
		firePropertyChange(P_SCOPE,null,scope);
	}
	
	public String getKey() {
		return key;
	}
	
	public void setKey(String key) {
		this.key = key;
		firePropertyChange(P_KEY,null,key);
	}
	
	public String getPath() {
		return path;
	}
	
	public void setPath(String path) {
		this.path = path;
		firePropertyChange(P_PATH,null,path);
	}
	
	public String getType() {
		return type;
	}
	
	public void setType(String type) {
		this.type = type;
		firePropertyChange(P_TYPE,null,type);
	}
	
	public Object getEditableValue() {
		return this;
	}
	
	public IPropertyDescriptor[] getPropertyDescriptors() {
		
		String[] paths = getRoot().getForwardPath();
		
		return new IPropertyDescriptor[]{
				new ClassSelectPropertyDescriptor(P_TYPE,"type(*)"),
				new TextPropertyDescriptor(P_KEY,"key(*)"),
				new ComboBoxPropertyDescriptor(P_PATH,"path",paths),
				new ClassSelectPropertyDescriptor(P_HANDLER,"handler"),
				new ClassSelectPropertyDescriptor(P_CLASS_NAME,"className"),
				new ScopePropertyDescriptor(P_SCOPE,"scope"),
				new TextPropertyDescriptor(P_ID,"id"),
				new TextPropertyDescriptor(P_BUNDLE,"bundle"),
				new PropertiesPropertyDescriptor(P_PROPERTIES,"properties"),
				new TextAreaPropertyDescriptor(P_COMMENT, "comment")
		};
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_TYPE)){
			return getType();
		} else if(id.equals(P_KEY)){
			return getKey();
		} else if(id.equals(P_PATH)){
			return new Integer(Util.getIndex(getRoot().getForwardPath(),path));
		} else if(id.equals(P_HANDLER)){
			return getHandler();
		} else if(id.equals(P_CLASS_NAME)){
			return getClassName();
		} else if(id.equals(P_SCOPE)){
			return ScopePropertyDescriptor.convertValue(scope);
		} else if(id.equals(P_ID)){
			return getId();
		} else if(id.equals(P_BUNDLE)){
			return getBundle();
		} else if(id.equals(P_PROPERTIES)){
			return getProperties();
		}
		return super.getPropertyValue(id);
	}
	
	public boolean isPropertySet(Object id) {
		if(id.equals(P_TYPE)||id.equals(P_KEY)||id.equals(P_PATH)||id.equals(P_HANDLER)||
				id.equals(P_CLASS_NAME)||id.equals(P_SCOPE)||id.equals(P_ID)||id.equals(P_BUNDLE)||
				id.equals(P_PROPERTIES)){
			return true;
		}
		return super.isPropertySet(id);
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_TYPE)){
			setType((String)value);
		} else if(id.equals(P_KEY)){
			setKey((String)value);
		} else if(id.equals(P_PATH)){
			setPath(getRoot().getForwardPath()[((Integer)value).intValue()]);
		} else if(id.equals(P_SCOPE)){
			setScope(ScopePropertyDescriptor.convertValue((Integer)value));
		} else if(id.equals(P_HANDLER)){
			setHandler((String)value);
		} else if(id.equals(P_CLASS_NAME)){
			setClassName((String)value);
		} else if(id.equals(P_ID)){
			setId((String)value);
		} else if(id.equals(P_BUNDLE)){
			setBundle((String)value);
		} else if(id.equals(P_PROPERTIES)){
			setProperties((Properties)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof GlobalExceptionModel){
			GlobalExceptionModel model = (GlobalExceptionModel)obj;
			if(model.getType().equals(getType()) && model.getPath().equals(getPath())){
				return true;
			}
		}
		return false;
	}
	
}
