package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;
import tk.eclipse.plugin.htmleditor.gefutils.TextAreaPropertyDescriptor;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.properties.BooleanPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.Properties;
import tk.eclipse.plugin.struts.properties.PropertiesPropertyDescriptor;

public class GlobalForwardModel extends AbstractModel implements IPropertySource {
	
	private static final long serialVersionUID = 4614209486484424996L;
	
	private String id              = "";
	private String name            = "";
	private String path            = "";
	private String className       = "";
	private String contextRelative = "";
	private String redirect        = "";
	private Properties properties = new Properties();
	private RootModel root;
	
	public static final String P_ID              = "_id";
	public static final String P_NAME            = "_name";
	public static final String P_PATH            = "_path";
	public static final String P_CLASSNAME       = "_class_name";
	public static final String P_CONTEXTRELATIVE = "_context_relative";
	public static final String P_REDIRECT        = "_redirect";
	public static final String P_PROPERTIES      = "_properties";
	
	public String getClassName() {
		return className;
	}
	
	public void setClassName(String className) {
		this.className = className;
		firePropertyChange(P_CLASSNAME,null,className);
	}
	
	public String getContextRelative() {
		return contextRelative;
	}
	
	public void setContextRelative(String contextRelative) {
		this.contextRelative = contextRelative;
		firePropertyChange(P_CONTEXTRELATIVE,null,contextRelative);
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public Properties getProperties() {
		return properties;
	}
	
	public void setProperties(Properties properties) {
		this.properties = properties;
		firePropertyChange(P_PROPERTIES,null,properties);
	}
	
	public String getRedirect() {
		return redirect;
	}
	
	public void setRedirect(String redirect) {
		this.redirect = redirect;
		firePropertyChange(P_REDIRECT,null,redirect);
	}
	
	public RootModel getRoot() {
		return root;
	}
	
	public void setRoot(RootModel root) {
		this.root = root;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		String oldValue = this.name;
		this.name = name;
		firePropertyChange(P_NAME,oldValue,name);
	}
	
	public String getPath() {
		return path;
	}
	
	public void setPath(String path) {
		this.path = path;
		firePropertyChange(P_PATH, null, path);
	}
	
	public IPropertyDescriptor[] getPropertyDescriptors() {
		
		String[] paths = getRoot().getForwardPath();
		
		return new IPropertyDescriptor[]{
				new TextPropertyDescriptor(P_NAME,"name(*)"),
				new ComboBoxPropertyDescriptor(P_PATH,"path(*)",paths),
				new TextPropertyDescriptor(P_ID,"id"),
				new ClassSelectPropertyDescriptor(P_CLASSNAME,"className"),
				new BooleanPropertyDescriptor(P_CONTEXTRELATIVE,"contextRelative"),
				new BooleanPropertyDescriptor(P_REDIRECT,"redirect"),
				new PropertiesPropertyDescriptor(P_PROPERTIES,"properties"),
				new TextAreaPropertyDescriptor(P_COMMENT, "comment")
		};
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_NAME)){
			return getName();
		} else if(id.equals(P_PATH)){
			return new Integer(Util.getIndex(getRoot().getForwardPath(),path));
		} else if(id.equals(P_ID)){
			return getId();
		} else if(id.equals(P_CLASSNAME)){
			return getClassName();
		} else if(id.equals(P_CONTEXTRELATIVE)){
			return BooleanPropertyDescriptor.convertValue(contextRelative);
		} else if(id.equals(P_REDIRECT)){
			return BooleanPropertyDescriptor.convertValue(redirect);
		} else if(id.equals(P_PROPERTIES)){
			return getProperties();
		}
		return super.getPropertyValue(id);
	}
	
	public boolean isPropertySet(Object id) {
		if(id.equals(P_NAME)||id.equals(P_PATH)||id.equals(P_ID)||id.equals(P_CLASSNAME)||
				id.equals(P_CONTEXTRELATIVE)||id.equals(P_REDIRECT)||id.equals(P_PROPERTIES)){
			return true;
		}
		return super.isPropertySet(id);
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_NAME)){
			setName((String)value);
		} else if(id.equals(P_PATH)){
			String[] paths = getRoot().getForwardPath();
			setPath(paths[((Integer)value).intValue()]);
		} else if(id.equals(P_ID)){
			setId((String)value);
		} else if(id.equals(P_CLASSNAME)){
			setClassName((String)value);
		} else if(id.equals(P_CONTEXTRELATIVE)){
			setContextRelative(BooleanPropertyDescriptor.convertValue((Integer)value));
		} else if(id.equals(P_REDIRECT)){
			setRedirect(BooleanPropertyDescriptor.convertValue((Integer)value));
		} else if(id.equals(P_PROPERTIES)){
			setProperties((Properties)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof GlobalForwardModel){
			GlobalForwardModel model = (GlobalForwardModel)obj;
			if(model.getPath().equals(getPath())){
				return true;
			}
		}
		return false;
	}
	
	public String toString(){
		return "global";
	}
}
