package tk.eclipse.plugin.struts.editors.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.struts.StrutsConfigRefactor;

public class PageModel extends AbstractEntityModel {
	
	private static final long serialVersionUID = -8496733268861330331L;
	
	private String path = "";
	private String moduleName = "";
	public static final String P_PATH = "_path";
    public static final String P_TILES_PATH = "_tiles_path";
    public static final String P_TILES_ATTR_PREFIX = "_tiles_attr_";
	
    protected boolean hasComment(){
    	return false;
    }
    
    public void setModuleName(String moduleName){
    	this.moduleName = moduleName;
    }
    
    public String getModuleName(){
    	return moduleName;
    }
    
	public void setPath(String path){
		if(!path.equals("/") && !path.startsWith("/")){
			if(path.indexOf(".jsp")!=-1){
				path = "/" + path;
			}
		}
		StrutsConfigRefactor.changePath(getRoot(),this.path,path);
		this.path = path;
		firePropertyChange(P_PATH,null,path);
	}
	
	public String getPath(){
		return path;
	}
    
    // (MVL) added
    public boolean isTile() {
        TilesRootModel tilesRoot = getRoot().getTilesRoot();
        return (tilesRoot != null && tilesRoot.getDefinition(path) != null);
    }
    
    // (MVL) added
    public String[] getPaths() {
        TilesRootModel tilesRoot = getRoot().getTilesRoot();
        if (tilesRoot != null) {
            TilesDefinitionModel definition = tilesRoot.getDefinition(path);
            if (definition != null) {
                List<String> paths = new ArrayList<String>();
                paths.add(definition.getPath(true));
                Map<String, TilesAttributeModel> attributes = definition.getAttributes(true);
                Iterator<TilesAttributeModel> it = attributes.values().iterator();
                while (it.hasNext()) {
                    TilesAttributeModel attr = it.next();
                    if (attr.isPageOrTemplate()) paths.add(attr.getValue());
                }
                return (String[]) paths.toArray(new String[paths.size()]);
            }
        }
        return null;
    }
	
	public IPropertyDescriptor[] getPropertyDescriptors() {
        // (MVL) also show tiles path and attributes in property view, if applicable
        TilesRootModel tilesRoot = getRoot().getTilesRoot();
        if (tilesRoot != null) {
            TilesDefinitionModel definition = tilesRoot.getDefinition(path);
            if (definition != null) {
                Map<String, TilesAttributeModel> attributes = definition.getAttributes(true);
                IPropertyDescriptor[] descriptors = new IPropertyDescriptor[2+attributes.size()];
                descriptors[0] = new TextPropertyDescriptor(P_PATH,"path");
                descriptors[1] = new PropertyDescriptor(P_TILES_PATH,"tile path");
                Iterator<TilesAttributeModel> it = attributes.values().iterator(); 
                for (int i=2; it.hasNext(); i++) {
                    TilesAttributeModel attr = it.next();
                    descriptors[i] = new PropertyDescriptor(P_TILES_ATTR_PREFIX+attr.getName(),"tile attribute: "+attr.getName());
                }
                return descriptors;
            }
        }
        // (MVL) end
		return new IPropertyDescriptor[]{
				new TextPropertyDescriptor(P_PATH,"path")
		};
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_PATH)){
			return getPath();
        // (MVL) get tiles path or attribute value
        } else if (id.equals(P_TILES_PATH)) {
            return getRoot().getTilesRoot().getDefinition(path).getPath(true);
		} else if (id instanceof String && ((String) id).startsWith(P_TILES_ATTR_PREFIX)) {
		    return getRoot().getTilesRoot().getDefinition(path)
                .getAttribute(((String) id).substring(P_TILES_ATTR_PREFIX.length()),true).getValue();
        }
        // (MVL) end
		return null;
	}
	
	public boolean isPropertySet(Object id) {
		if(id.equals(P_PATH)){
			return true;
		} else {
			return false;
		}
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_PATH)){
			setPath((String)value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof PageModel){
			if(((PageModel)obj).getPath().equals(getPath())){
				return true;
			}
		}
		return false;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		sb.append("page");
		sb.append(" path="+getPath());
		return sb.toString();
	}
	
	public boolean canSource(AbstractConnectionModel conn) {
        // (MVL) added:
        if (conn instanceof InputModel) {
            return true;
        }
		return false;
	}
	
	public boolean canTarget(AbstractConnectionModel conn) {
		if(conn instanceof ForwardModel || conn instanceof ExceptionModel){
			return true;
            // (MVL) added:
        } else if (conn instanceof DirectForwardModel || conn instanceof IncludeModel) {
            return true;
		}
		return false;
	}
}
