package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.Properties;
import tk.eclipse.plugin.struts.properties.PropertiesPropertyDescriptor;

public class PluginModel extends AbstractModel implements IPropertySource {
	
	private static final long serialVersionUID = -6394494734176121371L;
	
	private String id = "";
	private String className = "";
	private Properties properties = new Properties();
	
	public static final String P_ID = "_id";
	public static final String P_CLASSNAME  = "_class_name";
	public static final String P_PROPERTIES = "_properties";
	
	public PluginModel(){
		addPropertyDescriptor(P_CLASSNAME, new ClassSelectPropertyDescriptor(P_CLASSNAME,"className(*)"));
		addPropertyDescriptor(P_PROPERTIES, new PropertiesPropertyDescriptor(P_PROPERTIES,"properties"));
		addPropertyDescriptor(P_ID, new TextPropertyDescriptor(P_ID,"id"));
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
		firePropertyChange(P_CLASSNAME,null,className);
	}

	public Object getPropertyValue(Object id) {
		if(id.equals(P_CLASSNAME)){
			return getClassName();
		} else if(id.equals(P_PROPERTIES)){
			return getProperties();
		} else if(id.equals(P_ID)){
			return getId();
		}
		return super.getPropertyValue(id);
	}

	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_CLASSNAME)){
			setClassName((String)value);
		} else if(id.equals(P_PROPERTIES)){
			setProperties((Properties)value);
		} else if(id.equals(P_ID)){
			setId((String)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public Properties getProperties() {
		return properties;
	}
	
	public void setProperties(Properties properties) {
		this.properties = properties;
		firePropertyChange(P_PROPERTIES,null,properties);
	}
	
	public boolean equals(Object obj){
		if(obj instanceof PluginModel){
			PluginModel model = (PluginModel)obj;
			if(model.getClassName().equals(getClassName())){
				return true;
			}
		}
		return false;
	}
}
