package tk.eclipse.plugin.struts.editors.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/** RootModel of struts-config.xml */
public class RootModel extends AbstractModel {
	
	private static final long serialVersionUID = -9001040493620819987L;

	public static final String P_CHILDREN = "_children";
	
	/** an id attribute of a struts-config element */
	private String id = "";
	/** Element name of the DTD declaration */
	private String dtdName = "";
	/** SystemID of the DTD declaration */
	private String dtdPublicId = "";
	/** PublicID of the DTD declaration */
	private String dtdSystemId = "";
	/** Charset */
	private String charset = "";
	
	private List<AbstractEntityModel> children    = new ArrayList<AbstractEntityModel>();
	private List<AbstractModel> allChildren = new ArrayList<AbstractModel>();
	
	private GlobalForwardsModel   globalForwardsModel   = new GlobalForwardsModel();
	private GlobalExceptionsModel globalExceptionsModel = new GlobalExceptionsModel();
	private ActionMappingsModel   actionMappingsModel   = new ActionMappingsModel();
	private DataSourcesModel      dataSourcesModel      = new DataSourcesModel();
	private FormBeansModel        formBeansModel        = new FormBeansModel();
	
	public void setCharset(String charset){
		this.charset = charset;
	}
	
	public String getCharset(){
		return this.charset;
	}
	
	// (MVL) added
	private transient TilesRootModel tilesRoot = null;
	
	public void setTilesRoot(TilesRootModel tilesRoot) {
		this.tilesRoot = tilesRoot;
	}
	
	public TilesRootModel getTilesRoot() {
		return this.tilesRoot;
	}
	// (MVL) end
	
	public void setId(String id){
		this.id = id;
	}
	
	public String getId(){
		return id;
	}
	
	public String getDtdName() {
		return dtdName;
	}
	
	public void setDtdName(String dtdName) {
		this.dtdName = dtdName;
	}
	
	public String getDtdPublicId() {
		return dtdPublicId;
	}
	
	public void setDtdPublicId(String dtdPublicId) {
		this.dtdPublicId = dtdPublicId;
	}
	
	public String getDtdSystemId() {
		return dtdSystemId;
	}
	
	public void setDtdSystemId(String dtdSystemId) {
		this.dtdSystemId = dtdSystemId;
	}
	
	public FormBeansModel getFormBeansModel(){
		return this.formBeansModel;
	}
	
	public DataSourcesModel getDataSourcesModel(){
		return this.dataSourcesModel;
	}
	
	public GlobalForwardsModel getGlobalForwardsModel(){
		return this.globalForwardsModel;
	}
	
	public GlobalExceptionsModel getGlobalExceptionsModel(){
		return this.globalExceptionsModel;
	}
	
	public ActionMappingsModel getActionMappingsModel(){
		return this.actionMappingsModel;
	}
	
	/**
	 * Add a child model.
	 */
	public void addChild(Object child) {
		if(child instanceof AbstractEntityModel){
			((AbstractEntityModel) child).setRoot(this);
			children.add((AbstractEntityModel) child);
			allChildren.add((AbstractEntityModel) child);
			
		} else if(child instanceof GlobalForwardModel){
			((GlobalForwardModel) child).setRoot(this);
			allChildren.add((GlobalForwardModel) child);
			
		} else if(child instanceof GlobalExceptionModel){
			((GlobalExceptionModel) child).setRoot(this);
			allChildren.add((GlobalExceptionModel) child);
			
		} else if(child instanceof FormBeanModel){
			((FormBeanModel)child).setRoot(this);
			allChildren.add((FormBeanModel) child);
			
		} else if(child instanceof MessageResourcesModel){
			boolean addFlag = false;
			for(int i=allChildren.size()-1;i>=0;i--){
				Object obj = allChildren.get(i);
				if(!(obj instanceof PluginModel)){
					allChildren.add(i, (MessageResourcesModel) child);
					addFlag = true;
					break;
				}
			}
			if(addFlag==false){
				allChildren.add((MessageResourcesModel) child);
			}
		} else {
			allChildren.add((AbstractModel) child);
		}
		
		firePropertyChange(P_CHILDREN, null, child);
	}
	
	/**
	 * Returns a list of the visual models.
	 */
	public List<AbstractEntityModel> getViasualChildren() {
		return children;
	}
	
	/**
	 * Returns a list of all children.
	 */
	public List<AbstractModel> getChildren(){
		return allChildren;
	}
	
	/**
	 * Remove a child model.
	 */
	public void removeChild(Object child) {
		children.remove(child);
		allChildren.remove(child);
		firePropertyChange(P_CHILDREN, child, null);
	}
	
	/**
	 * Returns an array of path which can be specified as forward path (JSP and action).
	 * This array is sorted in order of the character string.
	 * And an empty string is added at the top of this array.
	 */
	public String[] getForwardPath(){
		List<String> list = new ArrayList<String>();
		list.add("");
		for(int i=0;i<children.size();i++){
			Object obj = children.get(i);
			if(obj instanceof ActionModel){
				list.add(((ActionModel)obj).getPath() + ".do");
			} else if(obj instanceof PageModel){
				list.add(((PageModel)obj).getPath());
			}
		}
		String[] array = list.toArray(new String[list.size()]);
		Arrays.sort(array);
		return array;
	}
	
	/**
	 * Returns a list of FormBeans.
	 * This array is sorted in order of the character string.
	 * And an empty string is added at the top of this array.
	 */
	public String[] getBeanNames(){
		List<String> list = new ArrayList<String>();
		list.add("");
		for(int i=0;i<allChildren.size();i++){
			Object obj = allChildren.get(i);
			if(obj instanceof FormBeanModel){
				list.add(((FormBeanModel) obj).getName());
			}
		}
		String[] array = list.toArray(new String[list.size()]);
		Arrays.sort(array);
		return array;
	}
	
//	public IPropertyDescriptor[] getPropertyDescriptors() {
//		return new IPropertyDescriptor[]{
//			new TextAreaPropertyDescriptor(P_COMMENT,"comment")
//		};
//	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		List<AbstractEntityModel> list = getViasualChildren();
		for(int i= 0 ; i < list.size(); i++){
			sb.append(list.get(i)).append("\n");
		}
		return sb.toString();
	}

}