package tk.eclipse.plugin.struts.editors.models;

import java.util.HashMap;
import java.util.Map;

public class TilesDefinitionModel {

    private TilesRootModel root = null;
    private Map<String, TilesAttributeModel> attributes = new HashMap<String, TilesAttributeModel>();
    private String name = null;
    private String path = null;
    private TilesDefinitionModel extendedDefinition = null;
    
    public TilesDefinitionModel() {
        super();
    }

    public void setRoot(TilesRootModel root) {
        this.root = root;
    }

    public TilesRootModel getRoot() {
        return root;
    }
    
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return getPath(false);
    }
    
    public String getPath(boolean includeInherited) {
        if (!includeInherited) {
            return path;
        } else if (path != null && !path.equals("")) {
            return path;
        } else {
            return extendedDefinition.getPath(true);
        }
    }

    public void setExtendedDefinition(TilesDefinitionModel extendedDefinition) {
        this.extendedDefinition = extendedDefinition;
    }

    public TilesDefinitionModel getExtendedDefinition() {
        return extendedDefinition;
    }

    public TilesAttributeModel getAttribute(String name) {
        return getAttribute(name, false);
    }
    
    public TilesAttributeModel getAttribute(String name, boolean includeInherited) {
        TilesAttributeModel result = (TilesAttributeModel) attributes.get(name);
        if (includeInherited && result == null && extendedDefinition != null) {
            result = extendedDefinition.getAttribute(name, true);
        }
        return result;
    }
    
    public Map<String, TilesAttributeModel> getAttributes() {
        return getAttributes(false);
    }
    
    public Map<String, TilesAttributeModel> getAttributes(boolean includeInherited) {
        if (!includeInherited) {
            return new HashMap<String, TilesAttributeModel>(attributes);
        } else if (extendedDefinition == null) {
            return new HashMap<String, TilesAttributeModel>(attributes);
        } else {
            Map<String, TilesAttributeModel> result = extendedDefinition.getAttributes(true);
            result.putAll(attributes);
            return result;
        }
    }
    
    public void addAttribute(TilesAttributeModel attribute) {
        attribute.setDefinition(this);
        attributes.put(attribute.getName(),attribute);
    }
    
    public void delAttribute(TilesAttributeModel attribute) {
        attributes.remove(attribute.getName());
        attribute.setDefinition(null);
    }
}
