package tk.eclipse.plugin.struts.editors.models;

import java.util.HashMap;
import java.util.Map;

public class TilesRootModel {

    private Map<String, TilesDefinitionModel> definitions = new HashMap<String, TilesDefinitionModel>();
    
    public TilesRootModel() {
        super();
    }
    
    public void addDefinition(TilesDefinitionModel definition) {
        definition.setRoot(this);
        definitions.put(definition.getName(),definition);
    }
    
    public void delDefinition(TilesDefinitionModel definition) {
        definitions.remove(definition.getName());
        definition.setRoot(null);
    }
    
    public TilesDefinitionModel getDefinition(String name) {
        return (TilesDefinitionModel) definitions.get(name);
    }
    
    public TilesDefinitionModel getOrAddDefinition(String name) {
        if (definitions.containsKey(name)) {
            return definitions.get(name);
        } else {
            TilesDefinitionModel model = new TilesDefinitionModel();
            model.setName(name);
            addDefinition(model);
            return model;
        }
    }
    
    public boolean existsDefinition(String name) {
        return definitions.containsKey(name);
    }
    
    public Map<String, TilesDefinitionModel> getDefinitions() {
        return new HashMap<String, TilesDefinitionModel>(definitions);
    }
    
    public void merge(TilesRootModel root) {
        definitions.putAll(root.getDefinitions());
    }

}
