package tk.eclipse.plugin.struts.editors.tree;

import java.beans.PropertyChangeEvent;
import java.util.List;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.editors.models.ActionModel;

public class ActionTreeEditPart extends AbstractMyTreeEditPart {

	protected List getModelChildren() {
		return ((ActionModel) getModel()).getModelSourceConnections();
	}

	protected void refreshVisuals() {
		ActionModel model = (ActionModel) getModel();
		setWidgetText(model.getPath());
		setWidgetImage(StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_ACTION));
	}

	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
		String propName = evt.getPropertyName();
        if (ActionModel.P_PATH.equals(propName)) {
            String path = (String) evt.getNewValue();
            if ("".equals(path)) {
                path = "<action>";
            }
            setWidgetText(path);
        }
	}

}
