package tk.eclipse.plugin.struts.editors.tree;

import java.beans.PropertyChangeEvent;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;

public class ExceptionTreeEditPart extends AbstractMyTreeEditPart {

	protected void refreshVisuals() {
		ExceptionModel model = (ExceptionModel)getModel();
		String type = model.getType();
		if (type == null || type.equals("")) {
			setWidgetText("<exception>");
		}
		setWidgetImage(StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_EXCEPTION));
	}

	public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        if (ExceptionModel.P_TYPE.equals(propName)) {
            String name = (String) evt.getNewValue();
            if (name == null || name.equals("")) {
            	setWidgetText("<exception>");
            } else {
            	setWidgetText(name);
            }
        }
	}

}
