package tk.eclipse.plugin.struts.editors.tree;

import java.beans.PropertyChangeEvent;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;

public class ForwardTreeEditPart extends AbstractMyTreeEditPart {

	protected void refreshVisuals() {
		ForwardModel model = (ForwardModel)getModel();
		setWidgetText(model.getName());
		setWidgetImage(StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_FORWARD));
	}

	public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        if (ForwardModel.P_NAME.equals(propName)) {
            String name = (String) evt.getNewValue();
            if ("".equals(name)) {
                name = "<forward>";
            }
            setWidgetText(name);
        }
	}

}
