package tk.eclipse.plugin.struts.editors.tree;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class RootTreeEditPart extends AbstractMyTreeEditPart {

	protected List getModelChildren() {
		// Action, Page, ʃW[̏ɂ܂ƂߒĕԂ
		List children = ((RootModel)getModel()).getChildren();
		List actionModelList = new ArrayList();
		List pageModelList = new ArrayList();
		List otherActionModelList = new ArrayList();
		Iterator it = children.iterator();
		while (it.hasNext()) {
			Object model = it.next();
			if (model instanceof ActionModel) {
				actionModelList.add(model);
			} else if (model instanceof PageModel) {
				pageModelList.add(model);
			}
		}
		List sortedChildren = new ArrayList(actionModelList);
		sortedChildren.addAll(pageModelList);
		sortedChildren.addAll(otherActionModelList);
		return sortedChildren;
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
		if(RootModel.P_CHILDREN.equals(propName)) {
			refreshChildren();
		}
	}
}
