package tk.eclipse.plugin.struts.editors.tree;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.DirectForwardModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.IncludeModel;
import tk.eclipse.plugin.struts.editors.models.InputModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class StrutsConfigTreeEditPartFactory implements EditPartFactory {

	public EditPart createEditPart(EditPart context, Object model) {
        EditPart part = null;
        if (model instanceof RootModel) {
            part = new RootTreeEditPart();
        } else if (model instanceof ActionModel) {
            part = new ActionTreeEditPart();
        } else if (model instanceof ForwardModel) {
            part = new ForwardTreeEditPart();
        } else if (model instanceof InputModel) {
            part = new InputTreeEditPart();
        } else if (model instanceof PageModel) {
            part = new PageTreeEditPart();
        } else if (model instanceof ExceptionModel) {
        	part = new ExceptionTreeEditPart();
        } else if (model instanceof DirectForwardModel) {
        	part = new DirectForwardTreeEditPart();
        } else if (model instanceof IncludeModel) {
        	part = new IncludeTreeEditPart();
        } else {
            return null;
        }
        part.setModel(model);
        return part;
	}

}
