package tk.eclipse.plugin.struts.properties;

import java.util.ResourceBundle;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import tk.eclipse.plugin.struts.StrutsPlugin;

/**
 * This is the base class of the dialog editing properties.
 * 
 * @author takezoe
 */
public abstract class AbstractPropertiesDialog extends Dialog {
	
	/** Table widget which lists properties */
	protected Table table;
	
	/** The header text of the fisrt columns */
	protected String labelName  = "name";
	
	/** The header text of the second columns */
	protected String labelValue = "value";
	
	protected ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
	
	protected void constrainShellSize() {
		getShell().setSize(350,200);
	}
	
	public AbstractPropertiesDialog(Shell parentShell) {
		super(parentShell);
		setShellStyle(getShellStyle()|SWT.RESIZE);
	}
	
	protected Control createDialogArea(Composite parent) {
		
		Composite container = new Composite(parent,SWT.NULL);
		
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		container.setLayout(layout);
		GridData gd = new GridData(GridData.FILL_BOTH);
		container.setLayoutData(gd);
		
		table = new Table(container,SWT.BORDER|SWT.FULL_SELECTION);
		table.setHeaderVisible(true);
		gd = new GridData(GridData.FILL_BOTH);
		gd.verticalSpan = 4;
		table.setLayoutData(gd);
		
		TableColumn col1 = new TableColumn(table,SWT.LEFT);
		col1.setText(labelName);
		col1.setWidth(100);
		
		TableColumn col2 = new TableColumn(table,SWT.LEFT);
		col2.setText(labelValue);
		col2.setWidth(150);
		
		final Button add = new Button(container,SWT.PUSH);
		add.setText(resource.getString("dialog.button.add"));
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.grabExcessHorizontalSpace = false;
		add.setLayoutData(gd);
		add.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent evt){
				addPressed();
			}
		});
		
		final Button remove = new Button(container,SWT.PUSH);
		remove.setText(resource.getString("dialog.button.remove"));
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.grabExcessHorizontalSpace = false;
		remove.setLayoutData(gd);
		remove.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent evt){
				removePressed();
			}
		});
		
		final Button edit = new Button(container,SWT.PUSH);
		edit.setText(resource.getString("dialog.button.edit"));
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.grabExcessHorizontalSpace = false;
		edit.setLayoutData(gd);
		edit.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent evt){
				editPressed();
			}
		});
		
		initDialog();
		
		return container;
	}
	
	protected abstract void editPressed();
	
	protected abstract void removePressed();
	
	protected abstract void addPressed();
	
	protected abstract void initDialog();
}
