package tk.eclipse.plugin.struts.properties;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * 
 * @author takezoe
 */
public class FormProperties implements Serializable {

	private static final long serialVersionUID = -8667484353165592093L;
	
	private ArrayList names      = new ArrayList();
	private ArrayList types      = new ArrayList();
	private ArrayList sizes      = new ArrayList();
	private ArrayList initials   = new ArrayList();
	private ArrayList classNames = new ArrayList();
	private ArrayList properties = new ArrayList();
	
	public void addProperty(String name,String type,String size,String initial,String className,
			                Properties property){
		names.add(name);
		types.add(type);
		sizes.add(size);
		initials.add(initial);
		classNames.add(className);
		properties.add(property);
	}
	
	public int size(){
		return names.size();
	}
	
	public Properties getProperties(int i){
		return (Properties)properties.get(i);
	}
	
	public String getClassName(int i){
		return (String)classNames.get(i);
	}
	
	public String getInitial(int i){
		return (String)initials.get(i);
	}
	
	public String getSize(int i){
		return (String)sizes.get(i);
	}
	
	public String getName(int i){
		return (String)names.get(i);
	}
	
	public String getType(int i){
		return (String)types.get(i);
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<size();i++){
			if(i!=0){
				sb.append(",");
			}
			sb.append(getName(i)+"("+getType(i)+")");
		}
		return sb.toString();
	}
}
