package tk.eclipse.plugin.struts.properties;

import java.util.ResourceBundle;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;

/**
 * The dialog to add and edit &lt;form-property&gt;.
 * 
 * @author takezoe
 */
public class FormPropertyDialog extends Dialog {
	
	private Text txtName;
//	private Text txtType;
	private Combo cmbType;
	private String name = "";
	private String type = "";

	private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();

	public FormPropertyDialog(Shell parentShell) {
		super(parentShell);
	}
		
	public FormPropertyDialog(Shell parentShell,String name,String type) {
		super(parentShell);
		this.name = name;
		this.type = type;
	}
	
	protected void constrainShellSize() {
		Shell shell = getShell();
		shell.pack();
		shell.setSize(300,shell.getSize().y);
	}
	
	protected Control createDialogArea(Composite parent) {
		
		getShell().setText("form-property");
		
		Composite container = new Composite(parent,SWT.NULL);
		GridData gd = new GridData(GridData.FILL_BOTH);
		container.setLayoutData(gd);
		
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		container.setLayout(layout);
		
		Label label = new Label(container,SWT.NULL);
		label.setText("&name(*):");
		
		txtName = new Text(container,SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		txtName.setLayoutData(gd);
		txtName.setText(name);
		
		label = new Label(container,SWT.NULL);
		label.setText("&type(*):");
		/*
		txtType = new Text(container,SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		txtType.setLayoutData(gd);
		txtType.setText(type);
		*/
		cmbType = new Combo(container,SWT.DROP_DOWN);
		cmbType.add("byte");
		cmbType.add("char");
		cmbType.add("int");
		cmbType.add("float");
		cmbType.add("short");
		cmbType.add("long");
		cmbType.add("double");
		cmbType.add("boolean");
		cmbType.add("java.lang.String");
		cmbType.add("java.lang.Character");
		cmbType.add("java.lang.Byte");
		cmbType.add("java.lang.Integer");
		cmbType.add("java.lang.Float");
		cmbType.add("java.lang.Short");
		cmbType.add("java.lang.Long");
		cmbType.add("java.lang.Double");
		cmbType.add("java.lang.Class");
		cmbType.add("java.sql.Date");
		cmbType.add("java.sql.Time");
		cmbType.add("java.sql.Timestamp");
		cmbType.add("java.math.BigDecimal");
		cmbType.add("java.math.BigInteger");
		
		gd = new GridData(GridData.FILL_HORIZONTAL);
		cmbType.setLayoutData(gd);
		
		cmbType.setText(type);
		
		return container;
	}
	
	protected void okPressed() {
		if(txtName.getText().equals("")){
			Util.openAlertDialog(Util.createMessage(
					resource.getString("error.required"),
					new String[]{"name"}));
			txtName.setFocus();
			return;
		}
		if(cmbType.getText().equals("")){
			Util.openAlertDialog(Util.createMessage(
					resource.getString("error.required"),
					new String[]{"type"}));
			cmbType.setFocus();
			return;
		}
		name = txtName.getText();
		type = cmbType.getText();
		super.okPressed();
	}
	
	public String getName(){
		return name;
	}
	
	public String getType(){
		return type;
	}
}
