package tk.eclipse.plugin.struts.properties;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * @author takezoe
 */
public class Properties implements Serializable {
	
	private static final long serialVersionUID = 5417601021473671365L;
	
	private ArrayList ids    = new ArrayList();
	private ArrayList names  = new ArrayList();
	private ArrayList values = new ArrayList();
	
	public void addProperty(String name,String value,String id){
		names.add(name);
		values.add(value);
		ids.add(id);
	}
	
	public int size(){
		return names.size();
	}
	
	public String getName(int i){
		return (String)names.get(i);
	}
	
	public String getValue(int i){
		return (String)values.get(i);
	}
	
	public String getId(int i){
		return (String)ids.get(i);
	}
	
	public boolean equals(Object obj){
		if(obj instanceof Properties){
			if(obj.toString().equals(toString())){
				return true;
			}
		}
		return false;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<size();i++){
			if(i!=0){
				sb.append(",");
			}
			sb.append(getName(i)+"="+getValue(i));
		}
		return sb.toString();
	}
	
}
