package tk.eclipse.plugin.struts.properties;

import java.util.ResourceBundle;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;

/**
 * The dialog to add or edit &lt;set-property&gt;.
 * 
 * @author takezoe
 */
public class PropertyDialog extends Dialog {
	
	private Text txtName;
	private Text txtValue;
	private String name  = "";
	private String value = "";
	
	protected ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
	
	public PropertyDialog(Shell parentShell) {
		super(parentShell);
	}
	
	public PropertyDialog(Shell parentShell,String name,String value) {
		super(parentShell);
		this.name  = name;
		this.value = value;
	}
	
	protected void constrainShellSize() {
		Shell shell = getShell();
		shell.pack();
		shell.setSize(300,shell.getSize().y);
	}
	
	protected Control createDialogArea(Composite parent) {
		
		getShell().setText("set-property");
		
		Composite container = new Composite(parent,SWT.NULL);
		GridData gd = new GridData(GridData.FILL_BOTH);
		container.setLayoutData(gd);
		
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		container.setLayout(layout);
		
		Label label = new Label(container,SWT.NULL);
		label.setText("&property(*):");
		
		txtName = new Text(container,SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		txtName.setLayoutData(gd);
		txtName.setText(name);
		
		label = new Label(container,SWT.NULL);
		label.setText("&value:");
		
		txtValue = new Text(container,SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		txtValue.setLayoutData(gd);
		txtValue.setText(value);
		
		return container;
	}
	
	protected void okPressed() {
		if(txtName.getText().equals("")){
			Util.openAlertDialog(Util.createMessage(
					resource.getString("error.required"),
					new String[]{"property"}));
			txtName.setFocus();
			return;
		}
		name  = txtName.getText();
		value = txtValue.getText();
		super.okPressed();
	}
	
	public String getName(){
		return name;
	}
	
	public String getValue(){
		return value;
	}
}
