package tk.eclipse.plugin.struts.properties;

import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;

/**
 * The PropertyDescriptor to edit scope of form-beans.
 * 
 * @author takezoe
 */
public class ScopePropertyDescriptor extends ComboBoxPropertyDescriptor {

	/**
	 * @param id
	 * @param displayName
	 */
	public ScopePropertyDescriptor(Object id, String displayName) {
		super(id, displayName, new String[]{"","request","session"});
	}
	
	public static Integer convertValue(String value){
		if(value!=null){
			if(value.equals("request")){
				return new Integer(1);
			} else if(value.equals("session")){
				return new Integer(2);
			}
		}
		return new Integer(0);
	}
	
	public static String convertValue(Integer value){
		int i = value.intValue();
		switch (i) {
			case 1: return "request";
			case 2: return "session";
		}
		return "";
	}

}
