package tk.eclipse.plugin.struts.validator;

import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

import tk.eclipse.plugin.struts.StrutsProject;

/**
 * This is a builder for the Struts project.
 * This validates struts-config.xml, tiles-defs.xml and validation.xml.
 * This validator is invoked according to the following timing:
 * <ul>
 *   <li>modified jsp files</li>
 *   <li>modified java files</li>
 *   <li>modified class files</li>
 *   <li>modified struts-config.xml</li>
 *   <li>modified .project</li>
 *   <li>modified .classpath</li>
 * </ul>
 * 
 * @author Naoki Takezoe
 */
public class StrutsProjectBuilder extends IncrementalProjectBuilder {
	
	@SuppressWarnings("unchecked")
	protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
		IProject project = getProject();
		if(project==null){
			return null;
		}
		IResourceDelta delta = getDelta(project);
		if(delta==null){
			return null;
		}
		
		StrutsProject strutsProject = new StrutsProject(project);
		
		if(processDelta(delta)){
			validateStrutsConfig(strutsProject);
			validateTiles(strutsProject);
			validateValidator(strutsProject);
//			new StrutsConfigValidator(strutsProject.getStrutsConfigXML()).doValidate();
		}
//		if(files!=null){
//			for(int i=0;i<files.length;i++){
//				new StrutsConfigValidator(files[i]).doValidate();
//			}
//		}
		getProject().refreshLocal(IResource.DEPTH_INFINITE,monitor);
		return null;
	}
	
	private boolean processDelta(IResourceDelta delta){
		if(delta.getKind()!=IResourceDelta.NO_CHANGE){
			String path = delta.getProjectRelativePath().toString();
			if(path.endsWith(".jsp") || path.endsWith(".java") || path.endsWith(".class") ||
			   path.endsWith(".xml") || path.endsWith(".project") || path.endsWith(".classpath")){
				return true;
			}
		}
		IResourceDelta[] children = delta.getAffectedChildren();
		for (IResourceDelta resourceDelta : children) {
			return processDelta(resourceDelta);
		}
		return false;
	}
	
	private void validateStrutsConfig(StrutsProject project){
		String[] modules = project.getModuleNames();
		for(int i=0;i<modules.length;i++){
			IFile[] files = project.getStrutsConfigXML(modules[i]);
			for(int j=0;j<files.length;j++){
				new StrutsConfigValidator(project,files[j],modules[i]).doValidate();
			}
		}
	}
	
	private void validateTiles(StrutsProject project){
		String[] modules = project.getModuleNames();
		for(int i=0;i<modules.length;i++){
			IFile[] files = project.getTilesXML(modules[i]);
			for(int j=0;j<files.length;j++){
				new TilesValidator(project,files[j],modules[i]).doValidate();
			}
		}
	}
	
	private void validateValidator(StrutsProject project){
		String[] modules = project.getModuleNames();
		for(int i=0;i<modules.length;i++){
			IFile[] files = project.getValidatorXML(modules[i]);
			for(int j=0;j<files.length;j++){
				new ValidatorValidator(project,files[j],modules[i]).doValidate();
			}
		}
	}
	
}
