package tk.eclipse.plugin.struts.wizards;

import java.util.ResourceBundle;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.template.StrutsJSPContextType;
import tk.eclipse.plugin.struts.template.StrutsTemplateAccess;

/**
 * The "New" wizard page allows setting the container for
 * the new file as well as the file name. The page
 * will only accept file name without the extension OR
 * with the extension that matches the expected one (mpe).
 */
public class JSPWizardPage extends WizardPage {
	
	private Text containerText;
	private Text fileText;
	private Combo templateCombo;
	private ISelection selection;
	private String fileName;
	private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
	private Template[] templates;
	
	/**
	 * Constructor for SampleNewWizardPage.
	 * @param pageName
	 */
	public JSPWizardPage(ISelection selection,String fileName) {
		super("wizardPage");
		setTitle(resource.getString("wizard.jsp.title"));
		setDescription(resource.getString("wizard.jsp.description"));
		this.selection = selection;
		this.fileName  = fileName;
	}

	/**
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;
		Label label = new Label(container, SWT.NULL);
		label.setText(resource.getString("wizard.label.container"));

		containerText = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		containerText.setLayoutData(gd);
		containerText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		Button button = new Button(container, SWT.PUSH);
		button.setText(resource.getString("wizard.label.browse"));
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleBrowse();
			}
		});
		label = new Label(container, SWT.NULL);
		label.setText(resource.getString("wizard.label.file"));

		fileText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		fileText.setLayoutData(gd);
		fileText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});
		
		// fill column
		label = new Label(container, SWT.NULL);
		
		label = new Label(container, SWT.NULL);
		label.setText(StrutsPlugin.getResourceString("wizard.label.template"));
		templateCombo = new Combo(container,SWT.READ_ONLY);
		templates = StrutsTemplateAccess.getDefault().getTemplateStore().getTemplates(
				StrutsJSPContextType.STRUTS_JSP_CONTEXT_TYPE);
		
		// add templates to the combobox
		for(int i=0;i<templates.length;i++){
			templateCombo.add(templates[i].getName());
		}
		// select first template
		if(templateCombo.getItemCount()>0){
			templateCombo.select(0);
		}
		
		initialize();
		dialogChanged();
		setControl(container);
	}
	
	/**
	 * Tests if the current workbench selection is a suitable
	 * container to use.
	 */
	private void initialize() {
		if (selection!=null && selection.isEmpty()==false && selection instanceof IStructuredSelection) {
			IStructuredSelection ssel = (IStructuredSelection)selection;
			if (ssel.size()>1) return;
			Object obj = ssel.getFirstElement();
			
			IResource  resource  = null;
			IContainer container = null;
			if(obj instanceof IResource){
				resource = (IResource)obj;
			} else if(obj instanceof IAdaptable){
				resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
			}
			if(resource!=null){
				if(resource instanceof IContainer){
					container = (IContainer)resource;
				} else {
					container = resource.getParent();
				}
			}
			if(container!=null){
				containerText.setText(container.getFullPath().toString());
			}
		}
		fileText.setText(fileName);
	}
	
	/**
	 * Uses the standard container selection dialog to
	 * choose the new value for the container field.
	 */
	private void handleBrowse() {
		ContainerSelectionDialog dialog =
			new ContainerSelectionDialog(
				getShell(),
				ResourcesPlugin.getWorkspace().getRoot(),
				false,
				resource.getString("wizard.message.selectContainer"));
		if (dialog.open() == ContainerSelectionDialog.OK) {
			Object[] result = dialog.getResult();
			if (result.length == 1) {
				containerText.setText(((Path)result[0]).toString());
			}
		}
	}
	
	/**
	 * Ensures that both text fields are set.
	 */
	private void dialogChanged() {
		String container = getContainerName();
		String fileName = getFileName();

		if (container.length() == 0) {
			updateStatus(Util.createMessage(resource.getString("error.required"),
					new String[]{resource.getString("message.container")}));
			return;
		}
		
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IResource containerObj = root.findMember(new Path(container));
		if(containerObj==null || !containerObj.exists() || !(containerObj instanceof IContainer) || resource instanceof IWorkspaceRoot){
			updateStatus(Util.createMessage(resource.getString("error.invalidPath"),
					new String[]{container}));
			return;
		}
		
		if (fileName.length() == 0) {
			updateStatus(Util.createMessage(resource.getString("error.required"),
					new String[]{resource.getString("message.file")}));
			return;
		}
		
		IResource fileObj = root.findMember(new Path(container).append(fileName));
		if(fileObj!=null && fileObj.exists() && fileObj instanceof IFile){
			updateStatus(Util.createMessage(resource.getString("error.alreadyExists"),
					new String[]{fileName}));
			return;
		}
		
		int dotLoc = fileName.lastIndexOf('.');
		if (dotLoc != -1) {
			String ext = fileName.substring(dotLoc + 1);
			if (ext.equalsIgnoreCase("jsp") == false) {
				updateStatus(Util.createMessage(resource.getString("error.extention"),
						new String[]{"jsp"}));
				return;
			}
		}
		if(templateCombo.getText().equals("")){
			updateStatus(Util.createMessage(resource.getString("error.noTemplate"),new String[0]));
			return;
		}
		
		updateStatus(null);
	}

	private void updateStatus(String message) {
		setMessage(message, DialogPage.ERROR);
		setPageComplete(message == null);
	}
	
	/**
	 * Returns entered container name.
	 * 
	 * @return Container name
	 */
	public String getContainerName() {
		return containerText.getText();
	}
	
	/**
	 * Returns entered filename.
	 * 
	 * @return Filename
	 */
	public String getFileName() {
		return fileText.getText();
	}
	
	/**
	 * Returns selected template object.
	 * 
	 * @return Template
	 */
	public Template getTemplate(){
		String name = templateCombo.getText();
		for(int i=0;i<templates.length;i++){
			if(templates[i].getName().equals(name)){
				return templates[i];
			}
		}
		return null;
	}
}