package tk.eclipse.plugin.struts.wizards;

import java.util.ResourceBundle;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

import tk.eclipse.plugin.struts.StrutsPlugin;

/**
 * @author Naoki Takezoe
 */
public class StrutsWizardPage2 extends WizardPage {

	private Button validator;
	private Button tiles;
//	private ISelection selection;
	private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
	
	public StrutsWizardPage2(ISelection selection) {
		super("wizardPage");
		setTitle(resource.getString("wizard.pluginSupport.title"));
		setDescription(resource.getString("wizard.pluginSupport.decription"));
//		this.selection = selection;
	}
	
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 1;
		layout.verticalSpacing = 9;
		
		validator = new Button(container,SWT.CHECK);
		validator.setText(resource.getString("wizard.label.useValidatorPlugIn"));
		validator.setSelection(true);

		tiles = new Button(container,SWT.CHECK);
		tiles.setText(resource.getString("wizard.label.useTilesPlugIn"));
		tiles.setSelection(true);
		
		setControl(container);
	}
	
	public void setEnabled(boolean enabled){
		this.validator.setEnabled(enabled);
		this.tiles.setEnabled(enabled);
	}

	public boolean getUseValidator(){
		return this.validator.getSelection();
	}
	
	public boolean getUseTiles(){
		return this.tiles.getSelection();
	}
	
}
