/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.functions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import jp.sf.amateras.functions.utils.RequestUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4j {
    private static Map<String, String> loggerNameMap = new ConcurrentHashMap<String, String>();

    protected static String getLoggerName(String servletPath) {
        if (loggerNameMap.containsKey(servletPath)) {
            return loggerNameMap.get(servletPath);
        }
        String path = servletPath;
        String loggerName = "";
        if (path.endsWith(".jsp")) {
            loggerName = "jsp.";
            path = path.replaceFirst("\\.jsp$", "");
        }
        if ((path = path.replace('/', '.')).startsWith(".")) {
            path = path.substring(1);
        }
        loggerName = loggerName + path;
        loggerNameMap.put(servletPath, loggerName);
        return loggerName;
    }

    protected static Logger getLogger() {
        HttpServletRequest request = RequestUtils.getRequest();
        return Logger.getLogger((String)Log4j.getLoggerName(request.getServletPath()));
    }

    public static void trace(Object message) {
        Log4j.getLogger().trace(message);
    }

    public static void debug(Object message) {
        Log4j.getLogger().debug(message);
    }

    public static void info(Object message) {
        Log4j.getLogger().info(message);
    }

    public static void warn(Object message) {
        Log4j.getLogger().warn(message);
    }

    public static void error(Object message) {
        Log4j.getLogger().error(message);
    }

    public static void fatal(Object message) {
        Log4j.getLogger().fatal(message);
    }

    public static String printTrace(Object message) {
        return Log4j.print(Level.TRACE, message);
    }

    public static String printDebug(Object message) {
        return Log4j.print(Level.DEBUG, message);
    }

    public static String printWarn(Object message) {
        return Log4j.print(Level.WARN, message);
    }

    public static String printInfo(Object message) {
        return Log4j.print(Level.INFO, message);
    }

    public static String printError(Object message) {
        return Log4j.print(Level.ERROR, message);
    }

    public static String printFatal(Object message) {
        return Log4j.print(Level.FATAL, message);
    }

    public static boolean isTraceEnabled() {
        return Log4j.getLogger().isEnabledFor((Priority)Level.TRACE);
    }

    public static boolean isDebugEnabled() {
        return Log4j.getLogger().isEnabledFor((Priority)Level.DEBUG);
    }

    public static boolean isInfoEnabled() {
        return Log4j.getLogger().isEnabledFor((Priority)Level.INFO);
    }

    public static boolean isWarnEnabled() {
        return Log4j.getLogger().isEnabledFor((Priority)Level.WARN);
    }

    public static boolean isErrorEnabled() {
        return Log4j.getLogger().isEnabledFor((Priority)Level.ERROR);
    }

    public static boolean isFatalEnabled() {
        return Log4j.getLogger().isEnabledFor((Priority)Level.FATAL);
    }

    private static String print(Level level, Object message) {
        if (Log4j.getLogger().isEnabledFor((Priority)level)) {
            if (message == null) {
                return "null";
            }
            return message.toString();
        }
        return "";
    }
}

