/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.functions.filter;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sf.amateras.functions.utils.DateUtils;
import jp.sf.amateras.functions.utils.FunctionsProperties;
import jp.sf.amateras.functions.utils.RequestUtils;
import jp.sf.amateras.functions.utils.ResponseUtils;
import jp.sf.amateras.functions.utils.StringUtils;

public class FunctionsFilter
implements Filter {
    private static final String DATE_PATTERN = "datePattern";
    private static final String DATETIME_PATTERN = "datetimePattern";
    private static final String TIME_PATTERN = "timePattern";
    private static final String DEFAULT_ENCODING = "defaultEncoding";

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Properties properties = FunctionsProperties.getProperties();
        if (properties != null) {
            DateUtils.setDatePattern(properties.getProperty(DATE_PATTERN));
            DateUtils.setDatetimePattern(properties.getProperty(DATETIME_PATTERN));
            DateUtils.setTimePattern(properties.getProperty(TIME_PATTERN));
            StringUtils.setDefaultEncoding(properties.getProperty(DEFAULT_ENCODING));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RequestUtils.setRequest((HttpServletRequest)request);
        ResponseUtils.setResponse((HttpServletResponse)response);
        request.setAttribute("context", (Object)((HttpServletRequest)request).getContextPath());
        try {
            chain.doFilter(request, response);
        }
        finally {
            RequestUtils.removeRequest();
            ResponseUtils.removeResponse();
        }
    }
}

