/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.functions.utils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RequestUtils {
    private static ThreadLocal<HttpServletRequest> requests = new ThreadLocal();

    public static void setRequest(HttpServletRequest request) {
        requests.set(request);
    }

    public static HttpServletRequest getRequest() {
        return requests.get();
    }

    public static String getEncoding() {
        HttpServletRequest request = RequestUtils.getRequest();
        if (request != null) {
            return request.getCharacterEncoding();
        }
        return null;
    }

    public static void removeRequest() {
        requests.remove();
    }

    public static Object getAttribute(String name) {
        HttpSession session;
        HttpServletRequest request = RequestUtils.getRequest();
        Object obj = request.getAttribute(name);
        if (obj == null && (obj = (session = request.getSession()).getAttribute(name)) == null) {
            obj = session.getServletContext().getAttribute(name);
        }
        return obj;
    }
}

