/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.bean;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescImpl;
import jp.sf.amateras.mirage.bean.MapBeanDescImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDescFactory {
    private static Map<Class<?>, BeanDesc> cacheMap = new ConcurrentHashMap();
    private static boolean cacheEnabled = false;

    public static void setCacheEnabled(boolean cacheEnabled) {
        BeanDescFactory.cacheEnabled = cacheEnabled;
    }

    public static boolean isCacheEnabled() {
        return cacheEnabled;
    }

    public static BeanDesc getBeanDesc(Object obj) {
        if (obj instanceof Map) {
            return new MapBeanDescImpl((Map)obj);
        }
        return BeanDescFactory.getBeanDesc(obj.getClass());
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        if (clazz == Map.class) {
            return new MapBeanDescImpl();
        }
        if (cacheEnabled && cacheMap.containsKey(clazz)) {
            return cacheMap.get(clazz);
        }
        BeanDescImpl beanDesc = new BeanDescImpl(clazz);
        if (cacheEnabled) {
            cacheMap.put(clazz, beanDesc);
        }
        return beanDesc;
    }
}

