/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.session;

import java.sql.Connection;
import java.sql.DriverManager;
import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.mirage.SqlManagerImpl;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.dialect.HyperSQLDialect;
import jp.sf.amateras.mirage.dialect.MySQLDialect;
import jp.sf.amateras.mirage.dialect.OracleDialect;
import jp.sf.amateras.mirage.dialect.PostgreDialect;
import jp.sf.amateras.mirage.dialect.StandardDialect;
import jp.sf.amateras.mirage.exception.SessionException;
import jp.sf.amateras.mirage.provider.DefaultConnectionProvider;
import jp.sf.amateras.mirage.session.Session;
import jp.sf.amateras.mirage.util.StringUtil;

public class JDBCSessionImpl
implements Session {
    private SqlManager sqlManager;
    private DefaultConnectionProvider provider;
    private String driver;
    private String url;
    private String user;
    private String password;

    public JDBCSessionImpl(String driver, String url, String user, String password) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
        this.sqlManager = new SqlManagerImpl();
        this.sqlManager.setDialect(this.getDialect());
        this.provider = new DefaultConnectionProvider();
        this.sqlManager.setConnectionProvider(this.provider);
    }

    private Dialect getDialect() {
        if (this.url.startsWith("jdbc:mysql:")) {
            return new MySQLDialect();
        }
        if (this.url.startsWith("jdbc:postgresql:")) {
            return new PostgreDialect();
        }
        if (this.url.startsWith("jdbc:oracle:")) {
            return new OracleDialect();
        }
        if (this.url.startsWith("jdbc:hsqldb:")) {
            return new HyperSQLDialect();
        }
        return new StandardDialect();
    }

    public void begin() throws SessionException {
        try {
            if (StringUtil.isNotEmpty(this.driver)) {
                Class.forName(this.driver);
            }
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            conn.setAutoCommit(false);
            this.provider.setConnection(conn);
        }
        catch (Exception ex) {
            throw new SessionException("Failed to begin transaction.", ex);
        }
    }

    public void commit() throws SessionException {
        try {
            this.provider.getConnection().commit();
        }
        catch (Exception ex) {
            throw new SessionException("Failed to commit transaction.", ex);
        }
    }

    public SqlManager getSqlManager() throws SessionException {
        return this.sqlManager;
    }

    public void release() throws SessionException {
        if (this.provider instanceof DefaultConnectionProvider) {
            this.provider.releaseConnection();
        }
    }

    public void rollback() throws SessionException {
        try {
            this.provider.getConnection().rollback();
        }
        catch (Exception ex) {
            throw new SessionException("Failed to rollback transaction.", ex);
        }
    }
}

