/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.tool;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import jp.sf.amateras.mirage.annotation.PrimaryKey;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.dialect.StandardDialect;
import jp.sf.amateras.mirage.naming.DefaultNameConverter;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.tool.EntityGen;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.JdbcUtil;
import jp.sf.amateras.mirage.util.StringUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityGenTask
extends Task {
    private String driver = "";
    private String url = "";
    private String user = "";
    private String password = "";
    private String packageName = "entity";
    private String outputDir = ".";
    private String charset = "UTF-8";
    private String nameConverter = DefaultNameConverter.class.getName();
    private String dialect = StandardDialect.class.getName();
    private String valueTypes = "";
    private String generationType = "";
    private String catalog = null;
    private String schema = null;
    private String tableNamePattern = "";
    private String ignoreTableNamePattern = "";

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setNameConverter(String nameConverter) {
        this.nameConverter = nameConverter;
    }

    public void setGenerationType(String generationType) {
        this.generationType = generationType;
    }

    public void setValueType(String valueType) {
        this.valueTypes = valueType;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setIgnoreTableNamePattern(String ignoreTableNamePattern) {
        this.ignoreTableNamePattern = ignoreTableNamePattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (StringUtil.isEmpty(this.driver)) {
            throw new BuildException("driver is required.");
        }
        if (StringUtil.isEmpty(this.url)) {
            throw new BuildException("url is required.");
        }
        try {
            EntityGen entityGen = new EntityGen();
            entityGen.setPackageName(this.packageName);
            entityGen.setDialect(this.newInstance(Dialect.class, this.dialect));
            entityGen.setNameConverter(this.newInstance(NameConverter.class, this.nameConverter));
            if (StringUtil.isNotEmpty(this.generationType)) {
                if (this.generationType.equals("APPLICATION")) {
                    entityGen.setGenerationType(PrimaryKey.GenerationType.APPLICATION);
                } else if (this.generationType.equals("IDENTITY")) {
                    entityGen.setGenerationType(PrimaryKey.GenerationType.IDENTITY);
                } else if (this.generationType.equals("SEQUENCE")) {
                    entityGen.setGenerationType(PrimaryKey.GenerationType.SEQUENCE);
                }
            }
            if (StringUtil.isNotEmpty(this.valueTypes)) {
                for (String valueType : this.valueTypes.split(",")) {
                    entityGen.addValueType(this.newInstance(ValueType.class, valueType.trim()));
                }
            }
            Connection conn = this.createConnection();
            try {
                System.out.println("Generating entities...");
                DatabaseMetaData meta = conn.getMetaData();
                ResultSet rs = meta.getTables(this.catalog, this.schema, "%", new String[]{"TABLE"});
                while (rs.next()) {
                    String catalog = rs.getString("TABLE_CAT");
                    String schema = rs.getString("TABLE_SCHEM");
                    String tableName = rs.getString("TABLE_NAME");
                    if (StringUtil.isNotEmpty(this.tableNamePattern) && !tableName.matches(this.tableNamePattern) || StringUtil.isNotEmpty(this.ignoreTableNamePattern) && tableName.matches(this.ignoreTableNamePattern)) continue;
                    entityGen.saveEntitySource(new File(this.outputDir), this.charset, conn, tableName, catalog, schema);
                    System.out.println(String.format("  %s.%s", schema, tableName));
                }
                JdbcUtil.close(rs);
            }
            finally {
                JdbcUtil.close(conn);
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private <T> T newInstance(Class<T> type, String className) throws Exception {
        return (T)Class.forName(className).newInstance();
    }

    private Connection createConnection() throws Exception {
        Class.forName(this.driver);
        Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
        return conn;
    }
}

