/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import java.util.List;
import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DefaultSchemaLoader;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.dialect.IIndexType;
import net.java.amateras.db.dialect.ISchemaLoader;
import net.java.amateras.db.dialect.IndexType;
import net.java.amateras.db.dialect.TableDependencyCalculator;
import net.java.amateras.db.util.StringUtils;
import net.java.amateras.db.validator.DiagramErrors;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ForeignKeyMapping;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public abstract class AbstractDialect
implements IDialect {
    private IColumnType[] types;
    protected IIndexType[] indexTypes = new IIndexType[]{new IndexType("UNIQUE"), new IndexType("INDEX")};
    protected final String LS = System.getProperty("line.separator");
    protected final String TAB = "\t\t";
    protected String separator;

    public AbstractDialect(IColumnType[] types) {
        this(types, ";");
    }

    public AbstractDialect(IColumnType[] types, String separator) {
        this.types = types;
        this.separator = separator;
    }

    public IColumnType getColumnType(int sqlType) {
        int i = 0;
        while (i < this.types.length) {
            if (sqlType == this.types[i].getType()) {
                return this.types[i];
            }
            ++i;
        }
        return null;
    }

    public IColumnType getColumnType(String typeName) {
        IColumnType[] iColumnTypeArray = this.types;
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            IColumnType type = iColumnTypeArray[n2];
            if (type.getName().toUpperCase().equals(typeName.toUpperCase())) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public IColumnType getDefaultColumnType() {
        IColumnType[] types = this.getColumnTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i].getType() == 4) {
                return types[i];
            }
            ++i;
        }
        return types[0];
    }

    public IColumnType[] getColumnTypes() {
        return this.types;
    }

    public IIndexType[] getIndexTypes() {
        return this.indexTypes;
    }

    public IIndexType getDefaultIndexType() {
        return this.getIndexTypes()[0];
    }

    public IIndexType getIndexType(String typeName) {
        IIndexType[] iIndexTypeArray = this.getIndexTypes();
        int n = iIndexTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexType indexType = iIndexTypeArray[n2];
            if (indexType.getName().equals(typeName)) {
                return indexType;
            }
            ++n2;
        }
        return null;
    }

    public String createDDL(RootModel model, boolean schema, boolean drop, boolean alterTable, boolean comment) {
        List<TableModel> children = TableDependencyCalculator.getSortedTable(model);
        StringBuilder sb = new StringBuilder();
        StringBuilder additions = new StringBuilder();
        int i = children.size() - 1;
        while (i >= 0) {
            TableModel table = children.get(i);
            if (drop && !table.isLinkedTable()) {
                String tableName = this.getTableName(model, table, schema);
                this.createDropTableStatement(sb, tableName);
                sb.append(this.LS);
            }
            --i;
        }
        if (drop) {
            sb.append(this.LS);
        }
        for (TableModel table : children) {
            if (table.isLinkedTable()) continue;
            sb.append(this.createTableDDL(model, table, schema, drop, alterTable, comment, additions));
            sb.append(this.LS);
        }
        if (additions.length() > 0) {
            sb.append(this.LS);
            sb.append(additions.toString());
        }
        for (TableModel table : children) {
            String sql = table.getSql();
            if (sql == null || sql.trim().length() == 0) continue;
            sb.append(this.LS);
            sb.append(sql);
            sb.append(this.LS);
        }
        return sb.toString();
    }

    protected void createDropTableStatement(StringBuilder sb, String tableName) {
        sb.append("DROP TABLE IF EXISTS ").append(tableName).append(";");
    }

    protected String getTableName(RootModel root, TableModel table, boolean schema) {
        if (schema) {
            if (table.isLinkedTable() && StringUtils.isNotEmpty(table.getSchema())) {
                return String.valueOf(table.getSchema()) + "." + table.getTableName();
            }
            if (StringUtils.isNotEmpty(root.getJdbcSchema())) {
                return String.valueOf(root.getJdbcSchema()) + "." + table.getTableName();
            }
        }
        return table.getTableName();
    }

    public String createTableDDL(RootModel root, TableModel model, boolean schema, boolean drop, boolean alterTable, boolean comment, StringBuilder additions) {
        int additionsLength = additions.length();
        StringBuffer sb = new StringBuffer();
        String logicalName = model.getLogicalName();
        if (comment) {
            sb.append("/**********************************/").append(this.LS);
            sb.append("/* ");
            if (logicalName != null && logicalName.length() > 0) {
                sb.append(DBPlugin.getResourceString("ddl.tableName")).append(": ");
                sb.append(logicalName);
            } else {
                sb.append(DBPlugin.getResourceString("ddl.tableName")).append(": ");
                sb.append(this.getTableName(root, model, schema));
            }
            sb.append(" */").append(this.LS);
            sb.append("/**********************************/").append(this.LS);
        }
        sb.append("CREATE TABLE ").append(this.getTableName(root, model, schema)).append("(" + this.LS);
        ColumnModel[] columns = model.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (i != 0) {
                sb.append("," + this.LS);
            }
            sb.append("\t\t");
            sb.append(this.createColumnDDL(root, model, columns[i], schema, alterTable, additions));
            ++i;
        }
        ColumnModel[] primaryKeys = model.getPrimaryKeyColumns();
        if (alterTable && primaryKeys.length != 0) {
            String pkName = "IDX_" + model.getTableName() + "_PK";
            StringBuilder pkBuf = new StringBuilder();
            pkBuf.append("ALTER TABLE ").append(this.getTableName(root, model, schema));
            pkBuf.append(" ADD CONSTRAINT ").append(pkName).append(" PRIMARY KEY (");
            int i2 = 0;
            while (i2 < primaryKeys.length) {
                if (i2 != 0) {
                    pkBuf.append(", ");
                }
                pkBuf.append(primaryKeys[i2].getColumnName());
                ++i2;
            }
            pkBuf.append(")").append(this.separator).append(this.LS);
            additions.insert(additionsLength, pkBuf.toString());
        }
        if (!alterTable && primaryKeys.length > 1) {
            sb.append(",").append(this.LS);
            sb.append("  PRIMARY KEY (");
            int i3 = 0;
            while (i3 < primaryKeys.length) {
                if (i3 != 0) {
                    sb.append(", ");
                }
                sb.append(primaryKeys[i3].getColumnName());
                ++i3;
            }
            sb.append(")");
        }
        List<AbstractDBConnectionModel> connList = model.getModelSourceConnections();
        int i4 = 0;
        while (i4 < connList.size()) {
            block31: {
                AbstractDBConnectionModel conn = connList.get(i4);
                if (conn instanceof ForeignKeyModel) {
                    ForeignKeyMapping[] mappings;
                    ForeignKeyModel fk = (ForeignKeyModel)connList.get(i4);
                    ForeignKeyMapping[] foreignKeyMappingArray = mappings = fk.getMapping();
                    int n = mappings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ForeignKeyMapping mapping = foreignKeyMappingArray[n2];
                        if (mapping.getRefer() != null && mapping.getTarget() != null) {
                            ++n2;
                            continue;
                        }
                        break block31;
                    }
                    TableModel target = (TableModel)conn.getTarget();
                    StringBuilder fkBuf = new StringBuilder();
                    fkBuf.append("FOREIGN KEY (");
                    int j = 0;
                    while (j < mappings.length) {
                        if (j != 0) {
                            fkBuf.append(",");
                        }
                        fkBuf.append(mappings[j].getRefer().getColumnName());
                        ++j;
                    }
                    fkBuf.append(") REFERENCES ");
                    fkBuf.append(this.getTableName(root, target, schema));
                    fkBuf.append(" (");
                    j = 0;
                    while (j < mappings.length) {
                        if (j != 0) {
                            fkBuf.append(",");
                        }
                        fkBuf.append(mappings[j].getTarget().getColumnName());
                        ++j;
                    }
                    fkBuf.append(")");
                    if (alterTable) {
                        String fkName = "IDX_" + model.getTableName() + "_FK" + i4;
                        additions.append("ALTER TABLE ").append(this.getTableName(root, model, schema));
                        additions.append(" ADD CONSTRAINT ").append(fkName).append(" ");
                        additions.append(fkBuf.toString()).append(this.separator).append(this.LS);
                    } else {
                        sb.append("," + this.LS + "  ");
                        sb.append(fkBuf.toString());
                    }
                }
            }
            ++i4;
        }
        int index = 0;
        while (index < model.getIndices().length) {
            IndexModel indexModel = model.getIndices()[index];
            if (indexModel.getIndexType().getName().equals("UNIQUE")) {
                StringBuilder indexBuf = new StringBuilder();
                indexBuf.append("CONSTRAINT ").append(indexModel.getIndexName()).append(" UNIQUE ");
                indexBuf.append("(");
                int i5 = 0;
                while (i5 < indexModel.getColumns().size()) {
                    if (i5 != 0) {
                        indexBuf.append(", ");
                    }
                    indexBuf.append(indexModel.getColumns().get(i5));
                    ++i5;
                }
                indexBuf.append(")");
                if (alterTable) {
                    additions.append("ALTER TABLE ").append(this.getTableName(root, model, schema)).append(" ");
                    additions.append("ADD ").append(indexBuf.toString()).append(this.separator).append(this.LS);
                } else {
                    sb.append("," + this.LS + "  ");
                    sb.append(indexBuf.toString());
                }
            } else {
                additions.append("CREATE INDEX ").append(indexModel.getIndexName()).append(" ");
                additions.append("ON ").append(this.getTableName(root, model, schema)).append(" (");
                int i6 = 0;
                while (i6 < indexModel.getColumns().size()) {
                    if (i6 != 0) {
                        additions.append(", ");
                    }
                    additions.append(indexModel.getColumns().get(i6));
                    ++i6;
                }
                additions.append(")").append(this.separator).append(this.LS);
            }
            ++index;
        }
        sb.append(this.LS);
        sb.append(")").append(this.separator).append(this.LS);
        if (additions.length() != additionsLength) {
            additions.append(this.LS);
        }
        return sb.toString();
    }

    protected String createColumnDDL(RootModel root, TableModel tableModel, ColumnModel columnModel, boolean schema, boolean alterTable, StringBuilder additions) {
        StringBuffer sb = new StringBuffer();
        sb.append(StringUtils.rpad(columnModel.getColumnName(), 30));
        sb.append("\t\t").append(columnModel.getColumnType().getName());
        if (columnModel.getColumnType().supportSize() && columnModel.getSize().length() > 0) {
            sb.append("(").append(columnModel.getSize()).append(")");
        }
        if (columnModel.getDefaultValue().length() != 0) {
            sb.append("\t\t").append(" DEFAULT ").append(columnModel.getDefaultValue());
        }
        if (columnModel.isNotNull()) {
            sb.append("\t\t").append(" NOT NULL");
        } else {
            sb.append("\t\t").append(" NULL ");
        }
        if (columnModel.isPrimaryKey() && !alterTable && tableModel.getPrimaryKeyColumns().length == 1) {
            sb.append("\t\t").append(" PRIMARY KEY");
        }
        return sb.toString();
    }

    public ISchemaLoader getSchemaLoader() {
        return new DefaultSchemaLoader();
    }

    public void validate(DiagramErrors errors, RootModel model) {
    }

    public String getColumnMetadataSQL(String tableName) {
        return "SELECT * FROM \"" + tableName + "\"";
    }
}

