/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.db.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.amateras.db.dialect.IColumnType;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.dialect.ISchemaLoader;
import net.java.amateras.db.dialect.IndexType;
import net.java.amateras.db.util.NameConverter;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ForeignKeyMapping;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.IndexModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;
import org.eclipse.draw2d.geometry.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSchemaLoader
implements ISchemaLoader {
    @Override
    public void loadSchema(RootModel root, IDialect dialect, Connection conn, String[] tables, String catalog, String schema, boolean autoConvert) throws SQLException {
        if (tables.length == 0) {
            return;
        }
        int i = 0;
        while (i < tables.length) {
            TableModel table = this.getTableInfo(tables[i], dialect, conn, catalog, schema, autoConvert);
            List<AbstractDBEntityModel> children = root.getChildren();
            int j = 0;
            while (j < children.size()) {
                TableModel tableModel;
                AbstractDBEntityModel obj = children.get(j);
                if (obj instanceof TableModel && (tableModel = (TableModel)obj).getTableName().equals(table.getTableName())) {
                    table.setLogicalName(tableModel.getLogicalName());
                    table.setDescription(tableModel.getDescription());
                    table.setConstraint(tableModel.getConstraint());
                    ColumnModel[] columns = table.getColumns();
                    int k = 0;
                    while (k < columns.length) {
                        ColumnModel columnModel = tableModel.getColumn(columns[k].getColumnName());
                        if (columnModel != null) {
                            columns[k].setLogicalName(columnModel.getLogicalName());
                            columns[k].setDescription(columnModel.getDescription());
                        }
                        ++k;
                    }
                    root.removeChild(tableModel);
                    break;
                }
                ++j;
            }
            if (table.getConstraint() == null) {
                table.setConstraint(new Rectangle(10 + i * 50, 10 + i * 50, -1, -1));
            }
            root.addChild(table);
            ++i;
        }
        this.setForeignKeys(root, conn, catalog, schema);
    }

    protected TableModel getTableInfo(String tableName, IDialect dialect, Connection conn, String catalog, String schema, boolean autoConvert) throws SQLException {
        TableModel table = new TableModel();
        table.setTableName(tableName);
        if (autoConvert) {
            table.setLogicalName(NameConverter.physical2logical(table.getTableName()));
        } else {
            table.setLogicalName(table.getTableName());
        }
        DatabaseMetaData meta = conn.getMetaData();
        ArrayList<ColumnModel> list = new ArrayList<ColumnModel>();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(dialect.getColumnMetadataSQL(tableName));
        ResultSetMetaData rm = rs.getMetaData();
        ResultSet columns = meta.getColumns(catalog, schema, tableName, "%");
        while (columns.next()) {
            IColumnType type = dialect.getColumnType(columns.getString("TYPE_NAME"));
            if (type == null && (type = dialect.getColumnType(columns.getInt("DATA_TYPE"))) == null) {
                type = dialect.getDefaultColumnType();
            }
            ColumnModel column = new ColumnModel();
            column.setColumnName(columns.getString("COLUMN_NAME"));
            if (autoConvert) {
                column.setLogicalName(NameConverter.physical2logical(column.getColumnName()));
            } else {
                column.setLogicalName(column.getColumnName());
            }
            column.setColumnType(type);
            column.setSize(columns.getString("COLUMN_SIZE"));
            column.setNotNull(columns.getString("IS_NULLABLE").equals("NO"));
            int rmIndex = this.getResultSetMetaDataIndex(rm, column.getColumnName());
            if (rmIndex > 0) {
                column.setAutoIncrement(rm.isAutoIncrement(rmIndex));
            }
            list.add(column);
        }
        columns.close();
        ResultSet keys = meta.getPrimaryKeys(catalog, schema, tableName);
        while (keys.next()) {
            String columnName = keys.getString("COLUMN_NAME");
            int i = 0;
            while (i < list.size()) {
                ColumnModel column = (ColumnModel)list.get(i);
                if (column.getColumnName().equals(columnName)) {
                    column.setPrimaryKey(true);
                }
                ++i;
            }
        }
        keys.close();
        rs.close();
        stmt.close();
        table.setColumns(list.toArray(new ColumnModel[list.size()]));
        List<IndexModel> indices = this.loadIndexModels(tableName, dialect, conn, catalog, schema, list);
        table.setIndices(indices.toArray(new IndexModel[indices.size()]));
        return table;
    }

    protected List<IndexModel> loadIndexModels(String tableName, IDialect dialect, Connection conn, String catalog, String schema, List<ColumnModel> columns) throws SQLException {
        ArrayList<IndexModel> result = new ArrayList<IndexModel>();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getIndexInfo(catalog, schema, tableName, false, true);
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            if (indexName == null) continue;
            IndexModel indexModel = null;
            for (IndexModel index : result) {
                if (!index.getIndexName().equals(indexName)) continue;
                indexModel = index;
                break;
            }
            if (indexModel == null) {
                indexModel = new IndexModel();
                indexModel.setIndexName(indexName);
                indexModel.setIndexName(rs.getString("INDEX_NAME"));
                if (rs.getBoolean("NON_UNIQUE")) {
                    indexModel.setIndexType(new IndexType("INDEX"));
                } else {
                    indexModel.setIndexType(new IndexType("UNIQUE"));
                }
                result.add(indexModel);
            }
            indexModel.getColumns().add(rs.getString("COLUMN_NAME"));
        }
        rs.close();
        ArrayList<IndexModel> removeIndexModels = new ArrayList<IndexModel>();
        for (IndexModel indexModel : result) {
            ArrayList<String> pkColumns = new ArrayList<String>();
            for (ColumnModel columnModel : columns) {
                if (!columnModel.isPrimaryKey()) continue;
                pkColumns.add(columnModel.getColumnName());
            }
            if (indexModel.getColumns().size() != pkColumns.size()) continue;
            boolean isNotPk = false;
            int i = 0;
            while (i < indexModel.getColumns().size()) {
                if (!indexModel.getColumns().get(i).equals(pkColumns.get(i))) {
                    isNotPk = true;
                    break;
                }
                ++i;
            }
            if (isNotPk) continue;
            removeIndexModels.add(indexModel);
        }
        result.removeAll(removeIndexModels);
        return result;
    }

    protected int getResultSetMetaDataIndex(ResultSetMetaData rm, String columnName) throws SQLException {
        int i = 1;
        while (i < rm.getColumnCount()) {
            if (rm.getColumnName(i).equals(columnName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected void setForeignKeys(RootModel root, Connection conn, String catalog, String schema) throws SQLException {
        int i = 0;
        while (i < root.getChildren().size()) {
            TableModel table = (TableModel)root.getChildren().get(i);
            AbstractDBConnectionModel[] abstractDBConnectionModelArray = table.getModelSourceConnections().toArray(new AbstractDBConnectionModel[table.getModelSourceConnections().size()]);
            int n = abstractDBConnectionModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractDBConnectionModel connModel = abstractDBConnectionModelArray[n2];
                if (connModel instanceof ForeignKeyModel) {
                    connModel.detachSource();
                    connModel.detachTarget();
                }
                ++n2;
            }
            ++i;
        }
        DatabaseMetaData meta = conn.getMetaData();
        int i2 = 0;
        while (i2 < root.getChildren().size()) {
            TableModel table = (TableModel)root.getChildren().get(i2);
            ResultSet rs = meta.getImportedKeys(catalog, schema, table.getTableName());
            HashMap map = new HashMap();
            while (rs.next()) {
                String pkTable = rs.getString("PKTABLE_NAME");
                String pkColumn = rs.getString("PKCOLUMN_NAME");
                String fkTable = rs.getString("FKTABLE_NAME");
                String fkColumn = rs.getString("FKCOLUMN_NAME");
                String keyName = rs.getString("FK_NAME");
                if (root.getTable(pkTable) == null || root.getTable(fkTable) == null) continue;
                if (map.get(keyName) == null) {
                    HashMap<String, Object> entry = new HashMap<String, Object>();
                    entry.put("fkTable", fkTable);
                    entry.put("pkTable", pkTable);
                    entry.put("mappings", new ArrayList());
                    map.put(keyName, entry);
                }
                List mappings = (List)((Map)map.get(keyName)).get("mappings");
                ForeignKeyMapping mapping = new ForeignKeyMapping();
                mapping.setRefer(root.getTable(fkTable).getColumn(fkColumn));
                mapping.setTarget(root.getTable(pkTable).getColumn(pkColumn));
                mappings.add(mapping);
            }
            rs.close();
            for (Map.Entry entry : map.entrySet()) {
                Map entryMap = (Map)entry.getValue();
                List mappings = (List)entryMap.get("mappings");
                ForeignKeyModel fkeyModel = new ForeignKeyModel();
                fkeyModel.setForeignKeyName((String)entry.getKey());
                fkeyModel.setMapping(mappings.toArray(new ForeignKeyMapping[mappings.size()]));
                fkeyModel.setSource(root.getTable((String)entryMap.get("fkTable")));
                fkeyModel.setTarget(root.getTable((String)entryMap.get("pkTable")));
                fkeyModel.attachSource();
                fkeyModel.attachTarget();
            }
            ++i2;
        }
    }
}

